/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import java.text.DateFormat;

import org.eclipse.hyades.internal.execution.local.common.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

/*
* CONTEXT_ID nnwp0000 for host address entry field in node wizard page
*/
/*
* CONTEXT_ID nnwp0001 for host name entry field in node wizard page
*/
/*
* CONTEXT_ID nnwp0002 for port number entry field in node wizard page
*/
/*
* CONTEXT_ID nnwp0003 for delta time entry field in node wizard page
*/

public class TraceNodeUI
{
	protected Text      _nodeAddress;
	protected Text      _nodeName; 
	protected Text	 _portNumber;
	protected Text	 _hour;
	protected Text	 _min;
	protected Text	 _sec;
	protected Text	 _micsec;
	
	protected Group 	deltaTime;
	
	private boolean    _haveSeperator = true;
/**
 * TraceOptionsUI constructor comment.
 */
public TraceNodeUI(boolean haveSeperator)
{
	super();
	_haveSeperator = haveSeperator;
}

public TraceNodeUI() {
	super();
}

/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent com.ibm.swt.widgets.Composite
 */
public Composite createControl(Composite parent)
{
	Label label;

	Composite content = new Composite(parent, SWT.NONE);
	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=5;       
	content.setLayout(layout);
	GridData gd = new GridData();
	gd.verticalAlignment   = GridData.FILL;
	gd.horizontalAlignment = GridData.FILL;
	gd.grabExcessHorizontalSpace = true;
	gd.widthHint = 500; 
	content.setLayoutData(gd);

	if (_haveSeperator)
	{
		Label sep = new Label(content, SWT.SEPARATOR | SWT.HORIZONTAL);
		GridData sepGrid = new GridData(GridData.FILL_HORIZONTAL);
		sepGrid.horizontalSpan = 1;
		sep.setLayoutData(sepGrid);
	}
	
//  top level group
	Composite group = new Composite( content, SWT.NULL );   
	group.setLayoutData( GridUtil.createHorizontalFill() );
	layout = new GridLayout();
	layout.numColumns = 2;  
	layout.verticalSpacing=5;   
	group.setLayout( layout );
	
	Label label1 = new Label(group, SWT.NONE);
	label1.setText(UIPlugin.getResourceString("NODE_NAME"));
	_nodeName = new Text(group, SWT.SINGLE | SWT.BORDER);
	_nodeName.setLayoutData(GridUtil.createHorizontalFill());
	
	Label label2 = new Label(group, SWT.NONE);
	label2.setText(UIPlugin.getResourceString("NODE_ADDRESS")); 
	_nodeAddress = new Text(group, SWT.SINGLE | SWT.BORDER);
	_nodeAddress.setLayoutData(GridUtil.createHorizontalFill());

	Label label3 = new Label(group, SWT.NONE);
	label3.setText(UIPlugin.getResourceString("RAC_PORT_TEXT")); 
	_portNumber = new Text(group, SWT.SINGLE | SWT.BORDER);
	_portNumber.setLayoutData(GridUtil.createHorizontalFill());
	_portNumber.setText(String.valueOf(Constants.CTL_PORT_NUM_SERVER));

	deltaTime = new Group(content, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 9;
	layout.verticalSpacing=5;       
	deltaTime.setLayout(layout);
	deltaTime.setLayoutData(GridUtil.createHorizontalFill());
	deltaTime.setText(UIPlugin.getResourceString("STR_SYNCH_NODE_TIME"));
	
	label = new Label(deltaTime, SWT.NONE);
	label.setText(UIPlugin.getResourceString("STR_DELTA_TIME"));
	
	_hour = new Text(deltaTime, SWT.BORDER);
	gd = new GridData();
	gd.widthHint = 20;
	_hour.setLayoutData(gd);
	_hour.setTextLimit(3);
	label = new Label(deltaTime, SWT.NONE);
	label.setText(":");	
	
	_min = new Text(deltaTime, SWT.BORDER);
	gd = new GridData();
	gd.widthHint = 20;
	_min.setLayoutData(gd);
	_min.setTextLimit(2);
	label = new Label(deltaTime, SWT.NONE);
	label.setText(":");	
	
	_sec = new Text(deltaTime, SWT.BORDER);
	gd = new GridData();
	gd.widthHint = 20;
	_sec.setLayoutData(gd);
	_sec.setTextLimit(2);
	label.setText(":");	
	
	_micsec = new Text(deltaTime, SWT.BORDER);
	gd = new GridData();
	gd.widthHint = 40;
	_micsec.setLayoutData(gd);
	_micsec.setTextLimit(6);

	label = new Label(deltaTime, SWT.NONE);
	label.setText(UIPlugin.getResourceString("STR_DELTA_HMS"));	
	
	_nodeName.setFocus();
	
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_nodeAddress,
		UIPlugin.getPluginId()+".nnwp0000");
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_nodeName,
		UIPlugin.getPluginId()+".nnwp0001");
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_portNumber,
		UIPlugin.getPluginId()+".nnwp0002");
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_hour,
		UIPlugin.getPluginId()+".nnwp0003");
	
	return content;
}
/**
 * Insert the method's description here.
 * Creation date: (8/14/2001 1:14:45 PM)
 * @return org.eclipse.swt.widgets.Text
 */
public Text getAddressUI() {
	return _nodeAddress;
}
/**
 * Insert the method's description here.
 * Creation date: (8/14/2001 1:14:45 PM)
 * @return org.eclipse.swt.widgets.Text
 */
public Text getNodeNameUI() {
	return _nodeName;
}

public Text getPortNumberUI() {
	return _portNumber;
}

public Text getHourUI()
{
	return _hour;
}

public Text getMinUI()
{
	return _min;
}

public Text getSecUI()
{
	return _sec;
}

public Text getMicSecUI()
{
	return _micsec;
}

/**
 * Insert the method's description here.
 * Creation date: (8/14/2001 1:20:47 PM)
 * @param enable boolean
 */
public void setEnabled(boolean enable)
{
	_nodeName.setEnabled(enable);
	_nodeAddress.setEnabled(enable);
	//_portNumber.setEnabled(enable);
}

public double getDeltaTime()
{
	int hours = 0;
	try {
		hours = Integer.parseInt(_hour.getText());
	}
	catch(Exception exc)
	{		
	}
	
	int min = 0;
	try {
		min = Integer.parseInt(_min.getText());
	}
	catch(Exception exc)
	{		
	}
	int sec = 0;
	try {
		sec = Integer.parseInt(_sec.getText());
	}
	catch(Exception exc)
	{		
	}
	int micsec = 0;
	try {
		micsec = Integer.parseInt(_micsec.getText());
	}
	catch(Exception exc)
	{		
	}

	return ((double)hours*3600 + min*60 + sec)*1000000+micsec;
	
}

public void setDeltaTime(double delta)
{
	DateFormat df = DateFormat.getTimeInstance();
	
	try {
		int micsec = (int)(delta % 1000000);
		delta = delta / 1000000;
		int hour = (int)(delta / 3600);
		int min = (int)((delta % 3600) / 60);
		int sec = (int)((delta % 3600) % 60);
		_hour.setText(hour==0?"":String.valueOf(hour));
		_min.setText(min==0?"":String.valueOf(min));
		_sec.setText(sec==0?"":String.valueOf(sec));
		_micsec.setText(micsec==0?"":String.valueOf(micsec));
	}
	catch(Exception exc)
	{
		exc.printStackTrace();
	}
}

public void setShowDelta(boolean enable)
{
	deltaTime.setVisible(enable);
}


}
