/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLogUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LoggingAgentsPreferencePage
	extends PreferencePage
	implements IWorkbenchPreferencePage {

	private TraceLogUI _options;

	public LoggingAgentsPreferencePage() {
		super();
		setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (4/30/2001 12:10:51 PM)
	 * @param hosts java.lang.String
	 */
	private void addAgents(String agents) {
		if (agents != null && !agents.equals("")) {
			int idx = 0;

			while (idx != -1) {
				idx = agents.indexOf(",");

				if (idx != -1) {
					String agent = agents.substring(0, idx);
					_options.addAgent(agent);

					agents = agents.substring(idx + 1);

				} else {
					_options.addAgent(agents);
				}
			}
		}
	}
	protected Control createContents(Composite parent) {
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		UIPlugin.getPluginId()+".lapp0000");
		
		Composite composite = new Composite(parent, SWT.NONE);

		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);

		_options = new TraceLogUI();
		_options.createControl(composite);

		initializeValues();

		return composite;
	}
	/**
	 * Returns preference store that belongs to the our plugin.
	 * This is important because we want to store
	 * our preferences separately from the desktop.
	 *
	 * @return the preference store for this plugin
	 */
	protected IPreferenceStore doGetPreferenceStore() {
		return UIPlugin.getDefault().getPreferenceStore();
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();

		_options.reset();
		String agents = store.getDefaultString(TraceConstants.LOG_KEY);
		addAgents(agents);
	}
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {
		IPreferenceStore store = getPreferenceStore();

		String agents = store.getString(TraceConstants.LOG_KEY);
		addAgents(agents);
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		super.performDefaults();
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		UIPlugin.getDefault().savePluginPreferences();
		return true;
	}
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		IPreferenceStore store = getPreferenceStore();

		String agents = "";

		String[] items = _options.getAgents();
		for (int idx = 0; idx < items.length; idx++) {
			agents += "," + items[idx].trim();
		}

		if (agents.startsWith(",") && agents.length() > 1)
			agents = agents.substring(1);

		store.setValue(TraceConstants.LOG_KEY, agents);
	}
}