/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.hyades.trace.ui.*;

/**
 * An element with differently typed properties.
 * Changing a property sends out a DomainEvent.
 */
public class FilterTableElement
{
	public static final String P_VISIBILITY= "combo";
	public static final String P_TEXT= "string";
	public static final String P_METHOD= "method";	
	
	private String fText;
	private String fMethod="*";	
	private String fVisibility;

	protected static final String[] fVisibilityState = new String[] {UIPlugin.getResourceString("STR_EXCLUDE"), UIPlugin.getResourceString("STR_INCLUDE")};

	private FilterList fParent;

		/**
	 * Initialize a new TestElement from the given data.
	 */
	public FilterTableElement(String text, String method, String visibility)
	{
		fMethod = method;		
		fText = text;
		fVisibility = visibility;		
	}

    public void setParent(FilterList parent)
    {
    	fParent = parent;
    }
    
	public String getMethod() {
		
		return fMethod;
	}

	public String getText() {
		return fText;
	}
	public String getVisibility() {
		return fVisibility;
	}
/**
 * Insert the method's description here.
 * Creation date: (1/8/2001 3:11:58 PM)
 * @return int
 */
public int getVisibilityState()
{
	for(int idx=0; idx<fVisibilityState.length; idx++)
	{
	  if(fVisibilityState[idx].equals(fVisibility))
	    return idx;
	}

	return -1;
}
/**
 * Insert the method's description here.
 * Creation date: (1/8/2001 3:11:26 PM)
 * @return java.lang.Object[]
 */
public static String[] getVisibilityStates()
{
	return fVisibilityState;
}
	
	public void setMethod(String value) {
		fMethod= value;
		fParent.fireElementChanged(this, P_METHOD);				
	}
	
	public void setText(String value) {
		fText= value;
		
		fParent.fireElementChanged(this, P_TEXT);				
	}
	public void setVisibility(int value)
	{
		fVisibility= fVisibilityState[value];
		
		fParent.fireElementChanged(this, P_VISIBILITY);				
	}
	public void setVisibility(String value) {
		fVisibility= value;

		if(fParent != null)
			fParent.fireElementChanged(this, P_VISIBILITY);				
	}
	public String toString()
	{
		return (fText + "," + fVisibility);
	}
}
