/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.part.DrillDownAdapter;

/**
 * Implements a simple web style navigation metaphor for a <code>TreeViewer</code>.  
 * Home, back, and "drill into" functions are supported for the viewer,
 * <p>
 */
public class MonitorDrillDownAdapter extends DrillDownAdapter 
{
/**
 * Allocates a new DrillDownTreePart.
 *
 * @param tree the target tree for refocusing
 */
public MonitorDrillDownAdapter(TreeViewer tree)
{
	super(tree);
}
/**
 * Returns whether "go into" is possible for child tree.  This is only possible 
 * if the current selection in the client has one item and it has children.
 *
 * @return <code>true</code> if "go into" is possible; <code>false</code> otherwise
 */
public boolean canGoInto()
{
	try {
		return super.canGoInto();
	}
	catch(Exception exc)
	{
		return false;
	}
}
}
