/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.*;

import org.eclipse.jface.viewers.*;

public class ProfilingList implements IBasicPropertyConstants
{	
	ArrayList types = new ArrayList();	
	TableViewer fViewer;

	protected List listeners;

	public ProfilingList(TableViewer viewer)
	{
		fViewer = viewer;
	}
	public void add(ProfilingTypeElement element)
	{
		add(element, -1);
	}
/**
 * Insert the method's description here.
 * Creation date: (08/23/2000 11:25:58 AM)
 * @param elem com.ibm.itp.pd.ui.FilterTableElement
 * @param index int
 */
public void add(ProfilingTypeElement element, int index)
{
	if(index < 0)
		types.add(element);
	else	
		types.add(index, element);

}
	/**
 * 
 */
public void addElementChangedListener(ProfilingListContentProvider newListener) {

	if (newListener == null)
		return;
	if (listeners == null)
		listeners = new ArrayList();
	if (!listeners.contains(newListener))
		listeners.add(newListener);

}
/**
 * Insert the method's description here.
 * Creation date: (08/23/2000 11:34:27 AM)
 * @return java.util.Enumeration
 */
public Object[] elements()
{
	return types.toArray();	
}
/**
 * 
 */
public void fireElementChanged(ProfilingTypeElement changedElement,String changedProperty) {
	// forward change to content providers.
	if (listeners != null) {
		Iterator e = listeners.iterator();
		while (e.hasNext()) {
			ProfilingListContentProvider l = (ProfilingListContentProvider) e.next();
			l.elementChanged(changedElement,changedProperty);
		}
	}
}
	public Object getElementAt(int index) {
		return types.get(index);
	}
/**
 * Insert the method's description here.
 * Creation date: (11/13/2000 12:53:52 PM)
 * @return java.util.Vector
 */
public ArrayList getFilters()
{
	return (ArrayList)types.clone();
}
/**
 * Insert the method's description here.
 * Creation date: (09/18/2000 4:02:44 PM)
 * @return int
 */
public int getSize() {
	return types.size();
}
/**
 * Insert the method's description here.
 * Creation date: (08/22/2000 4:53:57 PM)
 */
public void removeAll()
{
	/*
   Object[] objects = new Object[filters.size()];
   filters.copyInto(objects);
   	*/
   types.clear();
}

public void removeElements(int idx[])
{
	if (idx == null) return;
	
	Vector removeList = new Vector();
	for (int i=0;i<idx.length;i++)
	{
		if (idx[i]!=-1)
		{
			Object element = types.get(idx[i]);
			removeList.add(element);
		}
	}
	types.removeAll(removeList);
}

/**
 * Insert the method's description here.
 * Creation date: (08/22/2000 3:48:34 PM)
 * @param idx int
 */
public Object removeElementAt(int idx)
{
	Object element = types.get(idx);

	if(element == null)
	  return null;
	  
	types.remove(element);
	
	return element;
/*
	//update ui	
	fViewer.update(new ViewerUpdate(ViewerUpdate.REMOVE,
					fViewer.getInput(),
					P_CHILDREN,
					new Object[] {element}));
					*/
}
	/**
 * Removes a listener for selection changes.
 */
public void removeElementChangedListener(ProfilingListContentProvider listener) {

	if (listeners != null)
		listeners.remove(listener);
}
/**
 * Insert the method's description here.
 * Creation date: (08/23/2000 11:34:27 AM)
 * @return java.util.Enumeration
 */
public Object[] uiElements()
{
	return types.toArray();
}
}

