/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;

public class AddWizard extends ProfileSetWizard {

	public AddWizard(TraceProfileOverviewUI overviewUI)
	{
		super(overviewUI);
	}
	
	
	public void initializeSet()
	{
	    String name = getNewProfileSetName();
		String description = UIPlugin.getResourceString("FILTER_SET_DEFAULT_DESCRIPTION");
		
		init(org.eclipse.ui.PlatformUI.getWorkbench(), null);
		setWindowTitle(UIPlugin.getResourceString("STR_ADD_PROFILINGSET_DLG"));

		IProfilingSet set = new ProfilingSet(name, name, description);
		
		Object [] profilingTypes = getProfilingSetsManagerCopy().getProfilingTypes().values().toArray();
		
		if (profilingTypes.length > 0)
			set.getProfilingTypes().add(((IProfilingSetType)profilingTypes[0]).getId());
		
		super.initializeSet(set);
	}
	
	private String getNewProfileSetName()
	{
		String defaultName = UIPlugin.getResourceString("FILTER_SET_DEFAULT_NAME");
		
		int i = 1;
		String name = defaultName;
		while (profileNameExists(name))
		{
			name = defaultName + " (" + i + ")";
			i++;
		}
		
		return name;
	}	
	
	protected String getSetId()
	{
		return null;
	}
}
