/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/*
* CONTEXT_ID olap0000 for open Logging Agent page
*/

public class OpenLogAgentPage  extends WizardPage 
{
	protected TraceLocationUI _locationUI;
	protected Text            _name;
	protected INavigator fViewer;
		
  public OpenLogAgentPage(String name, INavigator viewer)     

  {
	super(name);
	setTitle(UIPlugin.getResourceString("LOG_AGENT_TITLE")); 
	fViewer = viewer;
	  
	setDescription("");
  }    /**
 * Insert the method's description here.
 * Creation date: (08/22/2000 4:48:53 PM)
 * @param show boolean
 */ 
  public void createControl(Composite parent)
  {
	Label label;

	Composite content = new Composite(parent, SWT.NONE);
	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=5;       
	content.setLayout(layout);
	GridData gd = GridUtil.createFill();
	gd.widthHint = 500;
	gd.heightHint = 400;
	content.setLayoutData(gd);

	_locationUI = new TraceLocationUI();
	_locationUI.createControl(content);
	_locationUI.setEnabled(false);

	Composite nameGrp = new Composite(content, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 2;
	layout.verticalSpacing=5;       
	nameGrp.setLayout(layout);
	nameGrp.setLayoutData(GridUtil.createHorizontalFill());
	
	Label nameLabel = new Label(nameGrp, SWT.NONE);
	nameLabel.setText(UIPlugin.getResourceString("STR_AGENT_NAME"));
	_name = new Text(nameGrp, SWT.BORDER);
	_name.setLayoutData(GridUtil.createHorizontalFill());
	_name.setEnabled(false);
	
	setControl(content);

	populateData();
	
	 org.eclipse.ui.help.WorkbenchHelp.setHelp(
			  parent,
	   UIPlugin.getPluginId()+".olap0000");

  }  
  public boolean finish()
  {
	  return true;
  }  
/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 3:17:53 PM)
 */
protected void populateData()
{
	IResource sel = HyadesUtil.getSelectionFolder(fViewer);
	if(sel != null)
	   _locationUI.setLocation(sel.getFullPath().toOSString());
	
	TRCAgentProxy agent = ((OpenLogAgentWizard)getWizard()).getAgent();

	if(agent == null)
	  return;

	_locationUI.setMonitor(agent.getProcessProxy().getNode().getMonitor().getName());
	 
	_name.setText(agent.getName());
}
}
