/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileFiltersTab;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ProfileSetWizardPage3 extends WizardPage implements IProfileSetWizardPage {

	private ProfileFiltersTab _filterTab;
	
	private TraceProfileOverviewUI _overviewUI;	
	
	
	private Listener _listener = new Listener() {
		public void handleEvent(Event event) {
			_overviewUI.dataChanged();
		}
	};	

	public ProfileSetWizardPage3(String pageId, TraceProfileOverviewUI overviewUI) {
		super(pageId);
		setImageDescriptor(PDPluginImages.getImageDescriptor(PDPluginImages.IMG_UI_WZ_EDITPROFSET));
		_filterTab = new ProfileFiltersTab("name");
		_overviewUI = overviewUI;		
	}
	
	public void createControl(Composite parent) {
		Composite composite = _filterTab.createControl(parent);
		_filterTab.addListener(_listener);
		setControl(composite);
	}
	
	public void initializeFrom(ProfilingSetsManagerCopy copy) {
		Collection set = copy.getFilterSets().values();
		FilterSetElement[] array = new FilterSetElement[set.size()];			
		_filterTab.activateFilters((FilterSetElement[])set.toArray(array), copy.getDefaultFilterSet());
	}
	
	public boolean performApply(ProfilingSetsManagerCopy copy) {
		Map profilingFilters = copy.getFilterSets();
		profilingFilters.clear();
		ArrayList filters = _filterTab.getFilterSet();			
		for(int idx=0; idx<filters.size(); idx++)
		{
			FilterSetElement  elem = (FilterSetElement) filters.get(idx);
			profilingFilters.put(elem.getName(), elem);
		}

		String name = _filterTab.getActiveFilterSet();
		copy.setDefaultFilterSet((FilterSetElement)copy.getFilterSets().get(name));
		
		return true;
	}
}
