/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.launcher;

/**
 * Agent Controller option passed to the launcher configuration 
 */
public class ProfilingAttribute {
	
	protected String name;
	protected String value;
	
	/**
	 * attributes associated with each profiling set
	 * related with the attribute element of the profilingset 
	 * extension point
	 */
	public ProfilingAttribute(String name, String value) {
		super();
		
		this.name = name;
		this.value = value;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the value.
	 */
	public String getValue() {
		return value;
	}
	/**
	 * @param value The value to set.
	 */
	public void setValue(String value) {
		this.value = value;
	}
}
