/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.report.ReportManager;


/**
 * Contains utility methods to work with the Test UI classes and the wide
 * context constants.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class TestUI
implements ICommonConstants
{		
	/**
	 * File extension for the report resources
	 */
	public final static String REPORT_FILE_EXTENSION = "report";

	/**
	 * Open editor preference store for report resources
	 */
	public final static String REPORT_OPEN_EDITOR = "OpenReportEditor";
	
	public final static String OPEN_EDITOR = "openEditor";	
	public final static String SAVE_INTERVAL = "saveInterval";	
	public final static String EXECUTION_FILTER = "execFilter";	
	public static final String LOCALHOST_PORT = "localhost_port";
	public static final String DEFAULT_HOST_NAME = "default_host_name";

	/**
	 * Datapool export extension
	 */
	public final static String CSV_FILE_EXTENSION = "csv";

	/**
	 * Test UI report manager. 
	 */
	private static ReportManager reportManager;


	/**
	 * Disposes the resources used by this class.
	 */
	static void dispose()
	{
		if(reportManager != null)
		{
			reportManager.saveIntoPreferenceStore();
			reportManager.dispose();
			reportManager = null;
		}		
	}
	
	public static void monitorPreferences()
	{
		IPropertyChangeListener listener = new IPropertyChangeListener()
		{
			public void propertyChange(PropertyChangeEvent event)
			{
				if(SAVE_INTERVAL.equals(event.getProperty()))
				{
					if(SaveManager.getInstance().isRunning())
					{
						SaveManager.getInstance().stop();
						SaveManager.getInstance().start(TestUIPlugin.getInstance().getPreferenceStore().getLong(SAVE_INTERVAL));
					}
				}
			}
		};
		TestUIPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(listener);
	}

	/**
	 * Returns <code>true</code> if the file extension is supported or 
	 * <code>false</code> otherwise.
	 * 
	 * @param fileExtension
	 * @return boolean
	 */
	public static boolean isSupportedFileExtension(String fileExtension)
	{
		if(TEST_SUITE_FILE_EXTENSION.equals(fileExtension))
			return true;

		if(DEPLOYMENT_FILE_EXTENSION.equals(fileExtension))
			return true;
			
		if(LOCATION_FILE_EXTENSION.equals(fileExtension))
			return true;
		
		if(ARTIFACT_FILE_EXTENSION.equals(fileExtension))
			return true;
		
		if(EXECUTION_FILE_EXTENSION.equals(fileExtension))
		    return true;
		
		if(DATAPOOL_FILE_EXTENSION.equals(fileExtension))
			return true;

		return false;
	}
	
	/**
	 * Returns the supported file extension as a sorted string
	 * array.
	 * @return String[]
	 */	
	public static String[] getSupportedFileExtensions()
	{	
		return new String[]{DEPLOYMENT_FILE_EXTENSION, LOCATION_FILE_EXTENSION, ARTIFACT_FILE_EXTENSION, TEST_SUITE_FILE_EXTENSION, EXECUTION_FILE_EXTENSION, DATAPOOL_FILE_EXTENSION};
	}
	
	/**
	 * Returns the report manager for the Test UI plugin. 
	 * @return ReportManager
	 */
	public static ReportManager getReportManager()
	{
		if(reportManager == null)
		{
			reportManager = new ReportManager(TestUIPlugin.getInstance(), HyadesUIPlugin.EP_REPORT_EXTENSIONS);
			reportManager.loadFromPluginRegistry();
			reportManager.loadFromPreferenceStore();
		}
		
		return reportManager;
	}
}
