/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceSelectionDialog;
import org.eclipse.hyades.test.ui.internal.model.ui.AddChildAction;
import org.eclipse.hyades.test.ui.util.ArtifactUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;

/**
 * This class handles the action when the Add button of the Artifact editor is selected
 * to add a new test asset association.
 * 
 * @author bjiang
 * @since  3.0
 */
public class AddTestAssetAction extends AddChildAction
{

    /**
     * Sole Contructor.
     * @param text
     */
    public AddTestAssetAction()
    {
        super(Common_ConfigurationPackage.eINSTANCE.getCFGArtifact(), TestUIPlugin.getString("BTN_ADD")); //$NON-NLS-1$);
        setToolTipText(TestUIPlugin.getString("ACT_TAST_ADD_TIP")); //$NON-NLS-1$
		//setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_TEST_ASSET));        
    }
    
    /**
	 * Sets the default artifact that is returned by 
	 * {@link #getArtifact(IStructuredSelection)}.  If <code>null</code> then the
	 * selection is analysed in order to identify the artifact.
	 * @param artifact
	 */
	public void setArtifact(CFGArtifact artifact)
	{
		setParent(artifact);
	}

	/**
	 * Returns the artifact associated with the first element of the structured 
	 * selection or <code>null</code>.
	 * @param structuredSelection
	 * @return CFGArtifact
	 */
	protected CFGArtifact getArtifact(IStructuredSelection structuredSelection)
	{
		return (CFGArtifact)getParent(structuredSelection);
	}	
	
	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		setActionPerformed(false);
		return (getArtifact(structuredSelection) != null);
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
	    EObjectResourceSelectionDialog fileDialog = new EObjectResourceSelectionDialog(Display.getCurrent().getActiveShell(), TestUIPlugin.getString("DLG_RESOURCE_SEL"), getSupportedFileExtensions(), null); //$NON-NLS-1$
		int ret = fileDialog.open();
		if(ret == Window.OK)
		{
			EObject[] eObjects = fileDialog.getSelectedObjects();
			if(eObjects != null && eObjects.length > 0)
			{
				CFGArtifact artifact = getArtifact(getStructuredSelection());
				for(int i = 0; i < eObjects.length; i++)
				{
				    if(!(eObjects[i] instanceof CFGClass))
				        continue;
				    
				    ArtifactUtil.associateTestAsset((CFGClass)eObjects[i], artifact);
				}
			}
		}
	}
	
	private String[] getSupportedFileExtensions()
	{
	    return new String[]{ICommonConstants.TEST_SUITE_FILE_EXTENSION, 
	            			ICommonConstants.TEST_COMPONENT_EXTENSION,
	            			ICommonConstants.SUT_EXTENSION,
	            			ICommonConstants.DATAPOOL_FILE_EXTENSION};
	}
}
