/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.dialog;

import java.util.List;
import java.util.Vector;

import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGConfigurableObject;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.Common_ConfigurationCategoryUtil;
import org.eclipse.hyades.models.common.configuration.util.ICategory;
import org.eclipse.hyades.models.common.configuration.util.ICategoryEnumeration;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/**
 * This is a default implementation used by {@link CFGConfigurableObject} editing page
 * to add a new {@link CFGComparableProperty} when add button is selected.
 * 
 * @author bjiang
 * @since	1.3
 */
public class ComparablePropertyInputDialog extends Dialog implements SelectionListener, ModifyListener
{
	private String title;
	private CCombo[] comboBoxes = new CCombo[3];
	private Button okButton;

	private CFGComparableProperty property;
	private ICategory[] categories;
	private String[] categoryDisplayNames;
	private String[] operators;
	
	public ComparablePropertyInputDialog(Shell shell, String title)
	{
		super(shell);
		this.title = title;
	}
	
	private ICategory[] getAllCategories()
	{
		if(categories == null)
		{
			categories = Common_ConfigurationCategoryUtil.getInstance().getCategories();
		}
		return categories;
	}
	
	private String[] getCategoryDisplayNames()
	{
		if(categoryDisplayNames == null)
		{
			ICategory[] categories = getAllCategories();
			categoryDisplayNames = new String[categories.length];
			for(int i = 0; i < categories.length; i++)
			{
				categoryDisplayNames[i] = categories[i].getDisplayName();
			}
		}
		return categoryDisplayNames;
	}
	
	private String[] getOperators()
	{
		if(operators == null)
		{
			operators = new String[]{"=", "!=", ">", "<", ">=", "<="};
		}
		return operators;
	}
	
	private String[] getEnumerationDisplayNames(ICategory category)
	{
		ICategoryEnumeration[] enum = Common_ConfigurationCategoryUtil.getInstance().getCategoryEnumeration(category);
		if(enum == null)
			return new String[0];
		Vector names = new Vector(200);
		for(int i = 0; i < enum.length; i++)
		{
			List values = enum[i].getIEnumerationValues();
			for(int j = 0; j < values.size(); j++)
			{
			 	names.add((String)values.get(j));	
			}
		}
		
		String[] returnList = new String[names.size()];
		for(int i = 0; i < names.size(); i++)
		{
			returnList[i] = (String)names.get(i);
		}
			
		return returnList;
	}

	protected Control createDialogArea(Composite parent)
	{
		Composite composite = (Composite)super.createDialogArea(parent);
		GridLayout layout = new GridLayout(3, false);
		composite.setLayout(layout);
		
		Label[] labels = new Label[3];
		for(int i = 0; i < 3; i++)
		{
			labels[i] = new Label(composite, SWT.WRAP);
			switch(i)
			{
				case 0:
					labels[i].setText(TestUIPlugin.getString("DLG_PROPERTY_NAME")); //$NON-NLS-1$
					break;
				case 1:
					labels[i].setText(TestUIPlugin.getString("DLG_OPERATOR")); //$NON-NLS-1$
					break;
				case 2:
					labels[i].setText(TestUIPlugin.getString("DLG_PROPERTY_VALUE")); //$NON-NLS-1$
					break;
				default:
					break;
			}
			
			GridData data = new GridData(
				GridData.HORIZONTAL_ALIGN_BEGINNING |
				GridData.VERTICAL_ALIGN_CENTER);
			//data.widthHint = convertHorizontalDLUsToPixels(IDialogConstants.MINIMUM_MESSAGE_AREA_WIDTH);;
			labels[i].setLayoutData(data);
			labels[i].setFont(parent.getFont());
		}
		
		
		comboBoxes[0]= new CCombo(composite, SWT.BORDER);
		comboBoxes[0].setItems(getCategoryDisplayNames());
		if(property != null && property.getName() != null)
			comboBoxes[0].setText(property.getName());
		GridData gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		gridData.widthHint = 150;
		comboBoxes[0].setLayoutData(gridData);
		comboBoxes[0].setSize(100, comboBoxes[0].getSize().y);
		comboBoxes[0].addSelectionListener(this);
		comboBoxes[0].addModifyListener(this);	
		comboBoxes[0].getAccessible().addAccessibleListener(new AccessibleAdapter() {				
			public void getName(AccessibleEvent e) {
				e.result = TestUIPlugin.getString("DLG_PROPERTY_NAME");
			}
		});
		
		comboBoxes[1]= new CCombo(composite, SWT.BORDER | SWT.READ_ONLY);
		comboBoxes[1].setItems(getOperators());
		if(property != null && property.getOperator() != null)
			comboBoxes[1].setText(property.getOperator());
		else
			comboBoxes[1].select(0);
		gridData = new GridData();
		gridData.widthHint = 50;
		comboBoxes[1].setLayoutData(gridData);
		comboBoxes[1].addModifyListener(this);
		comboBoxes[1].getAccessible().addAccessibleListener(new AccessibleAdapter() {				
			public void getName(AccessibleEvent e) {
				e.result = TestUIPlugin.getString("DLG_OPERATOR");
			}
		});
		
		comboBoxes[2]= new CCombo(composite, SWT.BORDER);
		if(property != null && property.getValue() != null)
			comboBoxes[2].setText(property.getValue());
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		gridData.widthHint = 150;
		comboBoxes[2].setLayoutData(gridData);
		comboBoxes[2].setSize(100, comboBoxes[2].getSize().y);
		comboBoxes[2].addModifyListener(this);
		comboBoxes[2].getAccessible().addAccessibleListener(new AccessibleAdapter() {				
			public void getName(AccessibleEvent e) {
				e.result = TestUIPlugin.getString("DLG_PROPERTY_VALUE");
			}
		});
		
		return composite;
	}
	
	/* (non-Javadoc)
	 * Method declared on Dialog.
	 */
	protected void buttonPressed(int buttonId) 
	{
		if (buttonId == IDialogConstants.OK_ID) {
			String name = comboBoxes[0].getText();
			int index = comboBoxes[0].indexOf(name);
			if(index > -1)
			    name = getAllCategories()[index].getName();
			
			String operator = comboBoxes[1].getText();
			String value = comboBoxes[2].getText();
			if(property == null)
				property = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
			property.setName(name);
			if(operator != null && operator.length() > 0)
				property.setOperator(operator);
			if(value != null && value.length() > 0)
				property.setValue(value);
		} else {
			property= null;
		}
		super.buttonPressed(buttonId);
	}
	
	/* (non-Javadoc)
	 * Method declared on Dialog.
	 */
	protected void createButtonsForButtonBar(Composite parent) {
		// create OK and Cancel buttons by default
		okButton = createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, true);
		okButton.setEnabled(false);
		createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CANCEL_LABEL, false);
	}	

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		if (title != null)
			shell.setText(title);
	}	
	
	protected void validateInput() 
	{
		String name = comboBoxes[0].getText();
		String operator = comboBoxes[1].getText();
		String value = comboBoxes[2].getText();
		if(name == null || name.length() < 1 ||
		   operator == null || operator.length() < 1 ||
		   value == null || value.length() < 1)
			okButton.setEnabled(false);
		else
			okButton.setEnabled(true);
	}

	public CFGComparableProperty getProperty()
	{
		return property;
	}
	
	public void setProperty(CFGComparableProperty prop)
	{
		this.property = prop;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e)
	{
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e)
	{
		if(e.widget == comboBoxes[0])
		{
			int index = comboBoxes[0].getSelectionIndex();
			if(index < 0)
				return;
				
			ICategory catg = getAllCategories()[index];
			String[] enum = getEnumerationDisplayNames(catg);
			comboBoxes[2].setItems(enum);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e)
	{
		validateInput();
	}

}
