/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.extension;

import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPartExtended;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.DataTableForm;
import org.eclipse.hyades.test.ui.internal.editor.form.DatapoolForm;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;

/**
 * @author psun
 */
public class DatapoolEditorExtension extends BaseEditorExtension implements IDatapoolPartExtended {

	private static final int PAGE_OVERVIEW = 0;
	private static final int PAGE_DATATABLE = 1;

	public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.Datapool"; //$NON-NLS-1$
	
	private DatapoolForm datapoolForm;
	private DataTableForm dataTableForm;


	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		datapoolForm.getWidgetFactory().dispose();
		datapoolForm.dispose();
		
		dataTableForm.dispose();

		super.dispose();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#createPages()
	 */
	public void createPages() {
		IHyadesEditorPart hyadesEditorPart = getHyadesEditorPart();
		WidgetFactory widgetFactory = new WidgetFactory();
		
		datapoolForm = new DatapoolForm(this, widgetFactory);
		hyadesEditorPart.addPage(datapoolForm.createControl());
		hyadesEditorPart.setPageText(PAGE_OVERVIEW, TestUIPlugin.getString("W_OVERVIEW")); //$NON-NLS-1$
	
		dataTableForm = new DataTableForm(this, widgetFactory);
		hyadesEditorPart.addPage(dataTableForm.createControl());
		hyadesEditorPart.setPageText(PAGE_DATATABLE, TestUIPlugin.getString("W_DATATABLE")); //$NON-NLS-1$
	
		datapoolForm.updateTitle();
	}

	/**
	 * Returns the datapool that is manipulated by this editor
	 * extension.
	 * @return DPLDatapool 
	 */
	public DPLDatapool getDatapool()
	{
		return (DPLDatapool)getHyadesEditorPart().getEditorObject();
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#getSelection()
	 */
	public IStructuredSelection getSelection()
	{
		switch(getHyadesEditorPart().getActivePage())
		{
			case PAGE_OVERVIEW:
				return new StructuredSelection(getDatapool());
				
		}
		
		return StructuredSelection.EMPTY;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#pageActivated(int)
	 */
	public boolean pageActivated(int index)
	{
		switch(index)
		{
			case PAGE_OVERVIEW:
				return datapoolForm.activated();				
		}
		
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#setSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void setSelection(IStructuredSelection structuredSelection)
	{
		if(structuredSelection.size() == 1)
		{
			Object object = structuredSelection.getFirstElement();
			if(object == getDatapool())
			{
				// don't do anything.
			}
		}
	}	

	/**
	 * @see org.eclipse.hyades.ui.util.IRefreshable#refreshContent(java.lang.Object)
	 */
	public void refreshContent(Object data)
	{
		datapoolForm.load();
		datapoolForm.updateTitle();
		dataTableForm.load();
		dataTableForm.updateTitle();
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPart#isReadOnly()
	 */
	public boolean isReadOnly() {
	 	return this.getHyadesEditorPart().isReadOnly();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPart#getActionBars()
	 */
	public IActionBars getActionBars() {
		return this.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPart#notifyEdit()
	 */
	public void notifyEdit() 
	{
	}
	
	public IEditorPart getEditorPart() {
		return this.getHyadesEditorPart().getEditorPart();
	}
	
}
