/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.swt.graphics.Image;

/**
 * @author jgout
 */
public class DefaultTestCaseProxyNode extends TypedElementProxyNode implements ITestCaseProxyNode {

	private IAssociationDescriptor descriptor;

	/**
	 * @param tc
	 * @param parent
	 */
	public DefaultTestCaseProxyNode(TPFTestCase tc, Object parent) {
		super(tc, parent);
		AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestCaseMappingRegistry();
		IAssociationMapping associationMapping = registry.getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS);
		descriptor = associationMapping.getDefaultAssociationDescriptor(tc.getType());
	}

	public Image getImage() {
		if(descriptor != null) {
			return descriptor.getImage();
		} else {
			//- the type of this element wasn't registered by any extension (hyades.ui.typeDescriptions)
			return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_CASE);
		}
	}

	public IProxyNode[] getChildren() {
		//- no children for a test case node
		return new IProxyNode[0];
	}
	
	public TPFTestCase getTestCase() {
		EObject tc = EMFUtil.getResourceSet().getEObject(getOriginatorURI(), true);
		if (tc instanceof TPFTestCase) {
			return (TPFTestCase) tc;
		} else {
			return null;
		}
	}
}
