/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.internal.SharedImages;

/**
 * @author jgout
 * @since 3.2
 */
public class FileProxyNode implements IProxyNode {
	
	private IFile file;
	private IProxyNode [] children;

	public FileProxyNode(IFile file) {
		//- file without children default file node
		this.file = file;
	}
		
	public String getText() {
		return file.getName();
	}

	public Image getImage() {
		SharedImages images = new SharedImages();
		return images.getImage(ISharedImages.IMG_OBJ_FILE);
	}

	public Object getParent() {
		return file.getParent();
	}

	public IProxyNode[] getChildren() {
		return children;
	}
	
	public void setChildren(IProxyNode[] children) {
		this.children = children;
	}
	
	public IFile getFile() {
		return file;
	}
	
	/** A file proxy node is by definition a root level node, its identifier is empty.
	 * 
	 */
	public String getIdentifier() {
		return ""; //$NON-NLS-1$
	}
	
	/** The underlying resource of a file proxy node is the file itself.
	 * 
	 */
	public IFile getUnderlyingResource() {
		return file;
	}

}
