/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyNode;
import org.eclipse.ui.views.properties.IPropertySource;

/** General proxy for typed element. 
 *  This class is derived for test suite, test case, test component and execution result
 * @author jgout
 */
public abstract class TypedElementProxyNode extends CMNNamedElementProxyNode implements ITypedElementProxyNode {
	private String type; 
	
	public TypedElementProxyNode(TPFTest test, Object parent) {
		super(test, parent);
		type = test.getType();
	}
	
	public TypedElementProxyNode(TPFExecutionResult exec, Object parent) {
		super(exec, parent);
		type = exec.getType();
	}
	
	public TypedElementProxyNode(TPFTestComponent testComponent, Object parent) {
		super(testComponent, parent);
		type = testComponent.getType();
	}
	
	public String getType() {
		return type;
	}
	
	public Object getAdapter(Class adapter) {
		return Platform.getAdapterManager().getAdapter(this, adapter);
	}

}
