/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.Iterator;
import java.util.Vector;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceContentProvider;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceLabelProvider;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

/**
 * @author psun
 * @author JLHoover 9/23/04
 * 
 * To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Generation - Code and Comments
 */
public class ArtifactSelectionPage extends WizardPage implements
		SelectionListener, ICheckStateListener {

	private Button filterButton;
	private CheckboxTreeViewer assetViewer;
	private EObjectResourceContentProvider contentProvider;
	private String[] fileExtensions;
	private Image fileImage;
	private EObject[] selectedEObjects;
	private EObject[] checkedEObjects;
	private Vector checkedObjects;

	/**
	 * @param pageName
	 */
	protected ArtifactSelectionPage(String pageName) {
		super(pageName);
		fileExtensions = getSupportedFileExtensions();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		GridData gridData = GridDataUtil.createFill();
		composite.setLayoutData(gridData);

		filterButton = new Button(composite, SWT.CHECK);
		filterButton.setText(TestUIPlugin.getString("SHOW_FOLDERS")); //$NON-NLS-1$
		filterButton.addSelectionListener(this);
		createViewer(composite);
		assetViewer.setInput(ResourcesPlugin.getWorkspace().getRoot());
		
		((Tree) assetViewer.getControl()).addSelectionListener(this);
		((TreeViewer) assetViewer).expandToLevel(2);
		
		setControl(composite);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		if (e.widget == filterButton) {
			contentProvider.setFilter((filterButton.getSelection() ? EObjectResourceContentProvider.SHOW_ALL
				: EObjectResourceContentProvider.FILTER_FOLDERS));
			ISelection selection = assetViewer.getSelection();			
			assetViewer.refresh();
			if (!selection.isEmpty())
				assetViewer.setSelection(selection, true);
		}

		if (e.widget == assetViewer.getControl()) {
			setSelection();
		}
	}

	private void setSelection() {
		ISelection selection = assetViewer.getSelection();
		if (selection != null && !selection.isEmpty()) {
			Iterator it = ((IStructuredSelection) selection).iterator();
			Vector objects = new Vector();
			while (it.hasNext()) {
				Object element = it.next();
				if (element instanceof EObject)
					objects.add((EObject) element);
			}
			selectedEObjects = new EObject[objects.size()];
			for (int i = 0; i < objects.size(); i++)
				selectedEObjects[i] = (EObject) objects.get(i);
		}
	}

	public EObject[] getSelectedObjects() {
		if (selectedEObjects == null)
			selectedEObjects = new EObject[0];

		return this.selectedEObjects;
	}

	public IFile[] getSelectedFiles() {
		if (selectedEObjects == null)
			return new IFile[0];

		IFile[] selectedFiles = new IFile[selectedEObjects.length];
		for (int i = 0; i < selectedEObjects.length; i++)
			selectedFiles[i] = EMFUtil.getWorkspaceFile(selectedEObjects[i]);

		return selectedFiles;
	}

	public EObject[] getCheckedObjects() {
		if (checkedEObjects == null)
			checkedEObjects = new EObject[0];

		return this.checkedEObjects;
	}

	public IFile[] getCheckedFiles() {
		if (checkedEObjects == null)
			return new IFile[0];

		IFile[] checkedFiles = new IFile[checkedEObjects.length];
		for (int i = 0; i < checkedEObjects.length; i++)
			checkedFiles[i] = EMFUtil.getWorkspaceFile(checkedEObjects[i]);

		return checkedFiles;
	}

	protected StructuredViewer createViewer(Composite parent) {
		Tree tree = new Tree(parent, SWT.MULTI | SWT.FULL_SELECTION | SWT.BORDER | SWT.CHECK);
		GridData gridData = GridDataUtil.createFill();
		gridData.heightHint = 150;
		tree.setLayoutData(gridData);

		contentProvider = new EObjectResourceContentProvider(fileExtensions);
		assetViewer = new CheckboxTreeViewer(tree);
		assetViewer.setContentProvider(contentProvider);
		assetViewer.setLabelProvider(new EObjectResourceLabelProvider(true, fileImage));
		assetViewer.addCheckStateListener(this);

		contentProvider.setFilter(EObjectResourceContentProvider.FILTER_FOLDERS);
		
		ViewerSorter sorter = new ViewerSorter() {
			public void sort(Viewer viewer, Object[] elements) {
				if (elements.length > 0)
					super.sort(viewer, elements);
			}

			public int category(Object element) {
				if (element instanceof IResource)
					return 0;

				return 10;
			}
		};
		assetViewer.setSorter(sorter);

		return assetViewer;
	}

	private String[] getSupportedFileExtensions() {
		return new String[] { ICommonConstants.TEST_SUITE_FILE_EXTENSION,
				ICommonConstants.TEST_COMPONENT_EXTENSION,
				ICommonConstants.SUT_EXTENSION,
				ICommonConstants.DATAPOOL_FILE_EXTENSION };
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ICheckStateListener#checkStateChanged(org.eclipse.jface.viewers.CheckStateChangedEvent)
	 */
	public void checkStateChanged(CheckStateChangedEvent event) {
		if (checkedObjects == null)
			checkedObjects = new Vector();

		Object element = event.getElement();
		Object [] childElements = null;
		int counter = 0;
		boolean skipListCopy = false;
		
		/*
		 * If the (un)checked element is a project(parent node) then all children
		 * need to mimick the parent.  A checkStateChanged event is not thrown
		 * when the child nodes are (un)checked so they must be added to/removed from the list
		 * of selected elements within the same event.
		 */
		if (element instanceof IProject || element instanceof IFolder) {
			assetViewer.setGrayed(element, false);
			if (assetViewer.getChecked(element)) {
				// check all child elements
				assetViewer.setSubtreeChecked(element, assetViewer.getChecked(element));
				childElements = assetViewer.getCheckedElements();
				counter = childElements.length;
			} else {
				childElements = assetViewer.getCheckedElements();
				// uncheck all child elements
				assetViewer.setSubtreeChecked(element, assetViewer.getChecked(element));
				counter = childElements.length;
			}
			 
			for (int j = 0; j < counter; j++) {
				if (!(childElements [j] instanceof IFolder) && !(childElements [j] instanceof IProject)) {
					if (event.getChecked()) {
						if (checkedObjects.contains(childElements [j]))
							skipListCopy = true;
						else
							checkedObjects.add(childElements [j]);
					} else {
						if (checkedObjects.contains(childElements [j]))
							checkedObjects.remove(childElements [j]);
						else
							skipListCopy = true;
					}

					if (!skipListCopy) {
						EObject[] modifiedList = new EObject[checkedObjects.size()];
						for (int i = 0; i < checkedObjects.size(); i++) {
							modifiedList[i] = (EObject) checkedObjects.get(i);
						}
						checkedEObjects = modifiedList;
					}
					skipListCopy = false;
				}
			}
		} else {
			/*
			 * Add or remove the individual child elements.  If removed and there is 
			 * a parent then the parent checkbox is grayed.
			 */
			if (event.getChecked()) {
				if (checkedObjects.contains(element))
					return;
				else
					checkedObjects.add(element);
			} else {
				if (checkedObjects.contains(element)) {
					assetViewer.setParentsGrayed(element, true);
					assetViewer.setGrayed(element, false);
					checkedObjects.remove(element);
				} else
					return;
			}

			EObject[] modifiedList = new EObject[checkedObjects.size()];
			for (int i = 0; i < checkedObjects.size(); i++) {
				modifiedList[i] = (EObject) checkedObjects.get(i);
			}
			checkedEObjects = modifiedList;
		}
	}
}