/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IFile;

/** Factory interface to produce a proxy from a file.
 *  Implementation of this interface should be used in the following extension point: 
 * <p><code>org.eclipse.hyades.test.ui.testNavigatorFileFactory</code></p>
 * @author jgout
 */
public interface IFileProxyFactory {
	
	/** Create a proxy node fromt the given file.
	 * 
	 * @param file the file to convert in proxy.
	 * @return a proxy which is used in the test navigator instead of the file itself.
	 */
	public IProxyNode create(IFile file);
	
}
