/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Image;

/** Main interface to wrap objects into the test navigator
 * @author jgout
 */
public interface IProxyNode {

	/** Returns the label used in the navigator to designate this node.
	 * @return the name of the node.
	 */
	public String getText();

	/** Returns the icon of this node used in the navigator.
	 * @return the icon of this node.
	 */
	public Image getImage();
	
	/** Returns the parent object of this node.
	 * @return the parent of this node.
	 */
	public Object getParent();
	
	/** Returns the array of children of this node. Children are proxies also.
	 * @return the array of children of this node.
	 */
	public IProxyNode[] getChildren();
	
	/** Returns the file system resource which this node comes from.   
	 * @return the file that contains this node.
	 */
	public IFile getUnderlyingResource();
	
	/** Returns a unique identifier within the underlying resource. 
	 *  If two instances of IProxyNode have the same identifier for the same underlying resource, this means that those proxies designate the same object.
	 * @return an string that identify the node in its underlying resource. 
	 */
	public String getIdentifier();
	
}
