/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

public class GetPropertyListCommand extends CommandElement implements Constants {

	protected RAString name = null;
	protected RAString type = null;
	protected RAString agentUUID = new RAString("");

	public GetPropertyListCommand() {
		super();
		_tag = RA_GET_PROPERTY_LIST;
	}

	public void setName(String str) {
		name = new RAString(str);
	}

	public RAString getName() {
		return name;
	}

	public void setType(String str) {
		type = new RAString(str);
	}

	public RAString getType() {
		return type;
	}

	public void setAgentUUID(String str) {
		agentUUID = new RAString(str);
	}

	public RAString getAgentUUID() {
		return agentUUID;
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		// Get the context value
		_context = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		// Get the name and type
		current = Message.readRAStringFromBuffer(buffer, current, name);
		current = Message.readRAStringFromBuffer(buffer, current, type);
		current = Message.readRAStringFromBuffer(buffer, current, agentUUID);

		return current;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = Message.writeRALongToBuffer(buffer, current, _tag);
		current = Message.writeRALongToBuffer(buffer, current, _context);
		current = Message.writeRAStringToBuffer(buffer, current, name);
		current = Message.writeRAStringToBuffer(buffer, current, type);
		current = Message.writeRAStringToBuffer(buffer, current, agentUUID);

		return current;
	}

	public int getSize() {
		int size = 0;

		size += sizeofLong; // tag
		size += sizeofLong; // context

		size += name.getSize(); // name
		size += type.getSize(); // type
		size += agentUUID.getSize(); // agentUUID

		return size;
	}

}
