/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.local.common;


/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ResourceLocation extends CommandElement implements Constants {

	protected long _port;
	protected RAString _jobKey = new RAString("");
	
	public ResourceLocation() {
		super();
		_tag=RA_RESOURCE_LOCATION;
	}
	
	public int getPort() {
		return (int)_port;
	}
	
	public String getJobKey() {
		return _jobKey.getData();
	}
	
	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#getSize()
	 */
	public int getSize() {
		return 3 * sizeofLong + _jobKey.getSize();
	}
	
	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#readFromBuffer(byte[], int)
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		
		int current=offset;
		_context=Message.readRALongFromBuffer(buffer, current);
		current+=sizeofLong;
		_port=Message.readRALongFromBuffer(buffer, current);
		current+=sizeofLong;
		current=Message.readRAStringFromBuffer(buffer, current, _jobKey);
		return current;
	}
	
	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#writeToBuffer(byte[], int)
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current=offset;
		current=Message.writeRALongToBuffer(buffer, current, _tag);
		current=Message.writeRALongToBuffer(buffer, current, _context);
		current=Message.writeRALongToBuffer(buffer, current, _port);
		current=Message.writeRAStringToBuffer(buffer, current, _jobKey);
		return current;
	}
}
