/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.control;

public class AgentFactory {
	
	/**
	 * Create a new agent instance with the specified name.
	 */
	public static Agent createAgent(Process process, String name) {
		return createAgent(process, name, null);
	}
	
	/**
	 * Create a new agent instance with the specified name and type.
	 */
	public static Agent createAgent(Process process, String name, String type) {
		Agent agent=new AgentImpl(process, name, type);
		try {
			((ProcessImpl)process).addAgent(agent);
			agent.addAgentListener((ProcessImpl)process);
		}
		catch(ClassCastException e) {
			/* Cannot set relationship unless process is a ProcessImpl */
		}
		return agent;
	}
}

