/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

/**
 * An abstract implementation of a IEditorExtension. A typical client 
 * subclasses this class implementing only the required methods.
 * 
 * <p>The clients must implement the following methods:<OL>
 * <LI><code>createPage()</code></LI>
 * <LI><code>doSave(IProgressMonitor)</code></LI>
 * </OL>
 * 
 * @author marcelop
 * @since 0.0.1
 */
public abstract class EditorExtension 
implements IEditorExtension
{
	private IHyadesEditorPart hyadesEditorPart;
		
	/**
	 * @see org.eclipse.hyades.ui.test.editor.IEditorExtension#init(org.eclipse.hyades.ui.test.editor.IHyadesEditorPart)
	 */
	public void init(IHyadesEditorPart hyadesEditorPart)
	throws PartInitException
	{
		this.hyadesEditorPart = hyadesEditorPart;
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#getHyadesEditorPart()
	 */
	public IHyadesEditorPart getHyadesEditorPart()
	{
		return hyadesEditorPart;
	}

	/**
	 * @see org.eclipse.hyades.ui.test.editor.IEditorExtension#gotoMarker(org.eclipse.core.resources.IMarker)
	 */
	public void gotoMarker(IMarker marker)
	{
	}

	/**
	 * @see org.eclipse.hyades.ui.test.editor.IEditorExtension#checkPagesDirtyState()
	 */
	public boolean checkPagesDirtyState()
	{
		return true;
	}

	/**
	 * @see org.eclipse.hyades.ui.test.editor.IEditorExtension#refreshPages()
	 */
	public boolean refreshPages()
	{
		return true;
	}

	/**
	 * @see org.eclipse.hyades.ui.test.editor.IEditorExtension#doSaveAs()
	 */
	public void doSaveAs()
	{
	}

	/**
	 * @see org.eclipse.hyades.ui.test.editor.IEditorExtension#isDirty()
	 */
	public boolean isDirty()
	{
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.test.editor.IEditorExtension#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed()
	{
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.test.editor.IEditorExtension#isSaveOnCloseNeeded()
	 */
	public boolean isSaveOnCloseNeeded()
	{
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.test.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		hyadesEditorPart = null;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.test.util.IRefreshable#refreshContent(java.lang.Object)
	 */
	public void refreshContent(Object data)
	{
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#setSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void setSelection(IStructuredSelection structuredSelection)
	{
	}
	
	/**
	 * @see org.eclipse.ui.ISelectionListener#selectionChanged(org.eclipse.ui.IWorkbenchPart, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection selection)
	{

	}
	
	/**
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter)
	{
		return null;
	}	

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#getStatusLineMessage(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public String getStatusLineMessage(IStructuredSelection structuredSelection)
	{
		return null;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#pageActivated(int)
	 */
	public boolean pageActivated(int index)
	{
		return false;
	}	
}
