/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.editor;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageEditorPart;

import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * Abstract multi-page editor part.  This editor is used to make public the
 * protected methods defined in MultiPageEditorPart that are present in the
 * IHyadesEditorPart interface.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public abstract class PageContainerEditorPart 
extends MultiPageEditorPart implements IHyadesEditorPart, IDisposable
{
	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getActivePage()
	 */
	public int getActivePage()
	{
		return super.getActivePage();
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getPageImage(int)
	 */
	public Image getPageImage(int pageIndex)
	{
		return super.getPageImage(pageIndex);
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getPageText(int)
	 */
	public String getPageText(int pageIndex)
	{
		return super.getPageText(pageIndex);
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#setActivePage(int)
	 */
	public void setActivePage(int pageIndex)
	{
		super.setActivePage(pageIndex);
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#setControl(int, org.eclipse.swt.widgets.Control)
	 */
	public void setControl(int pageIndex, Control control)
	{
		super.setControl(pageIndex, control);
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#setPageImage(int, org.eclipse.swt.graphics.Image)
	 */
	public void setPageImage(int pageIndex, Image image)
	{
		super.setPageImage(pageIndex, image);
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#setPageText(int, java.lang.String)
	 */
	public void setPageText(int pageIndex, String text)
	{
		super.setPageText(pageIndex, text);
	}
	
	/**
	 * @see IPageContainer#getContainerComposite()
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getContainer()
	 */
	public Composite getContainerComposite()
	{
		return super.getContainer();
	}
	
	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getControl(int)
	 */
	public Control getControl(int pageIndex)
	{
		return super.getControl(pageIndex);
	}
	
	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getEditor(int)
	 */
	public IEditorPart getEditor(int pageIndex)
	{
		return super.getEditor(pageIndex);
	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getPageCount()
	 */
	public int getPageCount()
	{
		return super.getPageCount();
	}
	
	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#setTitle(java.lang.String)
	 */
	public void setTitle(String title)
	{
		super.setTitle(title);
	}

	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#setTitleImage(org.eclipse.swt.graphics.Image)
	 */
	public void setTitleImage(Image titleImage)
	{
		super.setTitleImage(titleImage);
	}

	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#setTitleToolTip(java.lang.String)
	 */
	public void setTitleToolTip(String text)
	{
		super.setTitleToolTip(text);
	}
	
	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#firePropertyChange(int)
	 */
	public void firePropertyChange(int propertyId)
	{
		super.firePropertyChange(propertyId);
	}
	
	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#getContainer()
	 */
	public Composite getContainer()
	{
		return super.getContainer();
	}
}
