/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.editor.action;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IWorkbenchActionDefinitionIds;

import org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter;

public class RevertAction 
extends EditAction
{
	private IWorkbenchPart workbenchPart;
	
	public void setWorkbenchPart(IWorkbenchPart workbenchPart)
	{
		this.workbenchPart = workbenchPart;
		setEnabled((workbenchPart != null) && (workbenchPart instanceof IEditorPart) && ((IEditorPart)workbenchPart).isDirty() && (workbenchPart.getAdapter(ISynchronizedEditorAdapter.class) != null)); 
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#getActionDefinitionId()
	 */
	public String getActionDefinitionId()
	{
		return IWorkbenchActionDefinitionIds.REVERT_TO_SAVED;
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		if(workbenchPart != null)
		{
			Object adapter = workbenchPart.getAdapter(ISynchronizedEditorAdapter.class);
			if((adapter != null) && (adapter instanceof ISynchronizedEditorAdapter))
				((ISynchronizedEditorAdapter)adapter).reload();
		}
	}
}
