/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available a
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * # %Z% %I% %W% %G% %U% [%H% %T%]
 * 
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.internal.report;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.classloader.PathEntriesClassLoader;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.report.IReportGenerator;

public class ReportDescription implements IReportDescription
{
	private String name = null;
	private String className = null;
	private String classPath = null;
	private IReportGenerator reportGenerator = null;
	private IConfigurationElement configurationElement;
	private ClassLoader parentClassLoader;
	
	public ReportDescription(ClassLoader parentClassLoader, String name, String className, String classPath) {
		this.name = name;
		this.className = className;
		this.classPath = classPath;
		this.parentClassLoader = parentClassLoader;
	}
	
	public ReportDescription(String name, String className, String classPath, IConfigurationElement configurationElement) {
		this.name = name;
		this.className = className;
		this.classPath = classPath;
		this.configurationElement = configurationElement;
	}

	public String getName() {
		return name;
	}

	public String getClassName() {
		return className;
	}

	public String getClassPath() {
		return classPath;
	}

	public IReportGenerator getReportGenerator() throws Exception
	{
		if (reportGenerator == null)
		{
			if(configurationElement == null)
			{
				String className = getClassName();
				String classPath = getClassPath();
	
				PathEntriesClassLoader classLoader = new PathEntriesClassLoader(parentClassLoader, classPath);
				if (classLoader != null)
				{
					try
					{
						reportGenerator = (IReportGenerator)(classLoader.loadClass(className).newInstance());
					}
					catch(Throwable e)
					{
						HyadesUIPlugin.logError(e);
						return null;	
					}
					
					reportGenerator.setUsedClasspath(classPath);
				}
			}
			else
			{
				try
				{
					reportGenerator = (IReportGenerator)configurationElement.createExecutableExtension("class");
				}
				catch(Throwable e)
				{
					HyadesUIPlugin.logError(e);
					return null;	
				}
			}
		}
		
		return reportGenerator;
	}
	
	public boolean isDefinedByPlugin() {
		return (configurationElement != null);
	}

	/**
	 * @param string
	 */
	public void setClassName(String string) {
		className = string;
		reportGenerator = null;
	}

	/**
	 * @param string
	 */
	public void setClassPath(String string) {
		classPath = string;
		reportGenerator = null;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}
}