/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.util;

import org.eclipse.core.runtime.IAdaptable;

/**
 * Interface to define elements with name and description features.
 * 
 * @author marcelop
 * @since 0.0.1 
 */
public interface INamedElement
extends IAdaptable
{
	/**
	 * Returns this instance's name.
	 * @return String
	 */
	public String getName();

	/**
	 * Sets this instance's name.
	 * @param name
	 */
	public void setName(String name);

	/**
	 * Returns this instance's description.
	 * @return String
	 */	
	public String getDescription();
	
	/**
	 * Sets this instance's description.
	 * @param description
	 */
	public void setDescription(String description);
}
