/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.util;

/**
 * Interface for objects whose content may be refreshed.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public interface IRefreshable
{
	/**
	 * Refreshes this object. The <code>data</code> is an information that may
	 * be used during the process such as the tree item that should be 
	 * refreshed.
	 * @param data
	 */
	public void refreshContent(Object data);
}
