/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.recorder.ui.dialogs;

import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.internal.execution.recorder.local.RecorderClient;
import org.eclipse.hyades.internal.execution.testgen.ui.TestgenUIUtility;
import org.eclipse.hyades.internal.execution.testgen.ui.TestgenUIUtility.TestGenUIException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;


/**
 * Dialog for displaying progress and status while generating a test
 * @author Ernest Jessee
 */
public class RecorderProgressDialog extends Dialog
{

	private ProgressBar progressBar;
	private boolean ready;
	private Label infoText;
	private RecorderClient client;
	
	public RecorderProgressDialog()
	{
		super(Display.getDefault().getActiveShell());
	}

	public RecorderProgressDialog(final RecorderClient client)
	{
		super(Display.getDefault().getActiveShell());
		this.client = client;
		
	}
	/**
	 * @see org.eclipse.jface.window.Window#createContents(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createContents(Composite grandParent)
	{
		getShell().setText(RecorderPlugin.getResourceString("RecorderProgressDialog.TITLE")); //$NON-NLS-1$
		
		int width=400;
		int height=100;
		Composite base = grandParent.getParent();
		if(base==null)
			base = grandParent;
			
		/*grandParent.setBounds(base.getBounds().x+base.getBounds().width/2-width/2,
						      base.getBounds().y+base.getBounds().height/2-height/2,
							  width,
							  height);
		*/
		
		GridData gd = new GridData(GridData.GRAB_HORIZONTAL|GridData.FILL_BOTH);
		gd.heightHint = height;
		gd.widthHint = width;
		grandParent.setLayoutData(gd);
		

		Composite parent = new Composite(grandParent,SWT.NULL);
		gd = new GridData(GridData.GRAB_HORIZONTAL|GridData.FILL_BOTH);
		gd.heightHint = height;
		gd.widthHint = width;
		parent.setLayoutData(gd);
		
		TestgenUIUtility.assignFormLayout(parent);
		
		
		
		progressBar = new ProgressBar(parent,SWT.NULL);
		progressBar.setMaximum(100);
		progressBar.setMinimum(0);
		progressBar.setSelection(0);
		
		try
		{
			TestgenUIUtility.layoutCompositelInFormLayout(progressBar,45,15,10,90,0,0,0,0);
		}
		catch (TestGenUIException e)
		{
			e.printStackTrace();
		}	
		
		infoText = TestgenUIUtility.createLabel(parent,RecorderPlugin.getResourceString("RecorderProgressDialog.DEFAULT_MESSAGE"),null); //$NON-NLS-1$
		try
		{
			
			FontData[] defaultFonts = parent.getFont().getFontData();
			int textheight = 10;
			//FontData[].length is > 1 only for X
			//TODO: In X, determine which array member is being shown here, rather than getting largest
			for (int i = 0; i < defaultFonts.length; i++)
			{
				if (defaultFonts[i].getHeight() > textheight)
					textheight = defaultFonts[i].getHeight();
			}
			//TestgenUIUtility.layoutCompositelInFormLayout(infoText,60,15,10,100,0,0,0,0);
			TestgenUIUtility.layoutCompositelInFormLayout(infoText,60,textheight+6,10,100,0,0,0,0);
		}
		catch (TestGenUIException e1)
		{
			e1.printStackTrace();
		}

				
		
		setReady();
		
		return grandParent;
	}
	
	public void setProgress(int percentComplete)
	{
		progressBar.setSelection(percentComplete);
	
	}

	/**
	 * @return
	 */
	public synchronized boolean isReady()
	{
		return ready;
	}

	/**
	 * @param b
	 */
	public synchronized void setReady()
	{
		ready = true;
	}

	/**
	 * @param arg0
	 */
	public void setMessage(String message)
	{
		infoText.setText(message);
	}
	
	public void complete()
	{
		close();
	}
	
	public void setMaxProgress(int n)
	{
		if (n > 0)
			progressBar.setMaximum(n);		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.window.Window#close()
	 */
	public boolean close() {
		client.setProgressDlg(null);
		return super.close();
	}
}
