package org.eclipse.hyades.logging.core;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * A typed exception for all de-serialization APIs in
 * <code>org.eclipse.hyades.logging.core.XmlUtility</code> that de-serialize
 * an XML document to a Document Object Model (DOM).
 * </p>
 * 
 * @author Paul E. Slauenwhite
 * @version September 17, 2004
 * @since September 17, 2004
 * @see java.lang.Exception
 * @see org.eclipse.hyades.logging.core.XmlUtility
 */
public class DeserializationException extends Exception {

    /**
     * @see java.lang.Exception#Exception()
     */
    public DeserializationException() {
        super();
    }

    /**
     * @see java.lang.Exception#Exception(java.lang.String)
     */
    public DeserializationException(String message) {
        super(message);
    }
}