package org.eclipse.hyades.logging.core;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The main plug-in class for the org.eclipse.hyades.logging.core plug-in.
 * <p>
 * 
 * @author Paul E. Slauenwhite
 * @version August 26, 2004
 * @since August 26, 2004
 * @see org.eclipse.core.runtime.Plugin
 */
public class LoggingCorePlugin extends Plugin {
    
    //Singleton instance:
	private static LoggingCorePlugin instance = null;
	
	//Resource bundle:
	private ResourceBundle resourceBundle = null;
	
	/**
	 * No-argument constructor.
	 */
	public LoggingCorePlugin() {
		
	    super();

	    instance = this;		
	}

	/**
	 * Returns the singleton instance of this plugin class.
	 */
	public static LoggingCorePlugin getDefault() {
		
	    if(instance == null){
	        instance = new LoggingCorePlugin();
	    }
	    
	    return instance;
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		
	    try {

            ResourceBundle bundle = LoggingCorePlugin.getDefault().getResourceBundle();

            if (bundle != null) { 
                return (bundle.getString(key)); 
            }
        } 
	    catch (MissingResourceException m) {
            //Ignore since the API returns the resource key.
        }

        return key;
    }

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
	    
	    if (resourceBundle == null) {

            try {
                resourceBundle = Platform.getResourceBundle(getBundle());
            } 
            catch (MissingResourceException m) {
                //Ignore since API will return null.
            }
        }

        return resourceBundle;
	}
}
