/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.reports.hitrate;

import java.io.InputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.reports.HTTPReportGenerator;
import org.eclipse.hyades.test.http.internal.reports.ReportGraph;
import org.eclipse.hyades.test.http.internal.reports.ReportGraphConfiguration;
import org.eclipse.jface.viewers.ISelection;

/**
 * TODO: Provide description for "ReportGenerator1".
 * @see IReportGenerator
 */
public class HitRateReportGenerator extends HTTPReportGenerator
{
	

	/**
	 * TODO: Implement "generate".
	 * @see IReportGenerator#generate
	 */
	public InputStream generate(IFile outputFile, ISelection arg1) throws Exception 
	{	
		
		initResultSelection();
		if(result ==null)
			throw new Exception(TestHttpPlugin.getString("HitRateReportGenerator.ERROR")); //$NON-NLS-1$
			
		 
		HitRateReport report = new HitRateReport(result);
		
		report.generate();
		
		ReportGraphConfiguration config = setupConfiguration();
			
		ReportGraph graph = new ReportGraph(report.getList(),config);
		 
		IPath svgPath = outputFile.getFullPath(); 
		svgPath.removeFileExtension().addFileExtension("svg");  //$NON-NLS-1$
		return graph.generate(svgPath);		
		
		
	}


	private ReportGraphConfiguration setupConfiguration()
	{
		ReportGraphConfiguration config = new ReportGraphConfiguration();
		config.setTitle(TestHttpPlugin.getString("HitRateReportGenerator.HIT_RATE")); //$NON-NLS-1$
		config.setXTitle(TestHttpPlugin.getString("HitRateReportGenerator.PAGE")); //$NON-NLS-1$
		config.setYTitle(TestHttpPlugin.getString("HitRateReportGenerator.HITS_SEC")); //$NON-NLS-1$
		config.setLegendTitle(TestHttpPlugin.getString("HitRateReportGenerator.LEGEND")); //$NON-NLS-1$
		config.setTimeStampPrefix(""); //$NON-NLS-1$
		config.setMinWidth(800);
		config.setHeight(500);
		return config;
	}
}
