/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class HttpConstants
{
	public final static String HTTP_VERSION = "1.1";
	
	public final static String[] ALL_REQUEST_METHODS = new String[]
	{"CONNECT","DELETE","GET","HEAD","LINK","OPTIONS","POST","PUT","TRACE","UNLINK"};
	
	//The first method is the default one
	public final static String[] SUPPORTED_REQUEST_METHODS = new String[]
	{"GET", "POST"};
	
	public final static String[] GENERAL_HEADERS = new String[]
	{"Cache-Control","Connection","Date","Pragma","Trailer","Transfer-Encoding","Upgrade","Via","Warning"};
	
	public final static String[] ENTITY_HEADERS = new String[]
	{"Allow","Content-Encoding","Content-Language","Content-Length","Content-Location","Content-MD5","Content-Range","Content-Type","Expires","Last-Modified"};
	
	public final static String[] REQUEST_HEADERS = new String[]
	{"Accept","Accept-Charset","Accept-Encoding","Accept-Language","Authorization","Expect","From","Host","If-Match","If-Modified-Since","If-None-Match","If-Range","If-Unmodified-Since","Max-Forwards","Proxy-Authorization","Range","Referer","TE","User-Agent"};
		
	public final static String[] RESPONSE_HEADERS = new String[]
	{"Accept-Ranges","Age","ETag","Location","Proxy-Authenticate","Retry-After","Server","Vary","WWW-Authenticate"};
	
	// aberns:
	public final static long DEFAULT_THINK_TIME = 200; 
	
	public static String[] getAllHeaders()
	{
		ArrayList headers = new ArrayList(GENERAL_HEADERS.length + ENTITY_HEADERS.length + REQUEST_HEADERS.length + RESPONSE_HEADERS.length + 2);
		headers.addAll(Arrays.asList(GENERAL_HEADERS));
		headers.addAll(Arrays.asList(ENTITY_HEADERS));
		headers.addAll(Arrays.asList(REQUEST_HEADERS));
		headers.addAll(Arrays.asList(RESPONSE_HEADERS));
		
		Collections.sort(headers);
		return (String[])headers.toArray(new String[headers.size()]);
	}
}
