/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.manual;

import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * Image manager for the Test Manual plugin.
 *  
 * @author marcelop
 * @since 1.0.2
 */
public class TestManualImages
extends ImageManager
{
	/**
	 * TestManualImages' singleton.
	 */
	public static final TestManualImages INSTANCE = new TestManualImages();
	
	/*
	 * Available cached Images in the Manual plugin image registry.
	 */
	public static final String IMG_WIZBAN_NEW_MANUAL_TESTSUITE 		= "newmanual_wiz.gif";
	public static final String IMG_WIZBAN_NEW_MANUAL_TESTCASE 		= "newtest_wiz.gif";
	
	public static final String IMG_MANUAL_TEST_SUITE 					= "msuite.gif";
	public static final String IMG_MANUAL_TEST_CASE 				    = "test.gif";
	
	/**
	 * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
	 */
	protected void addImages()
	{
		add(T_WIZBAN, IMG_WIZBAN_NEW_MANUAL_TESTSUITE);
		add(T_WIZBAN, IMG_WIZBAN_NEW_MANUAL_TESTCASE);

		add(T_OBJ, IMG_MANUAL_TEST_SUITE);
		add(T_OBJ, IMG_MANUAL_TEST_CASE);
	}	
}
