/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.jonas.internal;

import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.utils.internal.SetVariableCommand;
//import org.eclipse.hyades.perfmon.utils.internal.ErrorListener;
import org.eclipse.hyades.perfmon.common.internal.*;

import org.eclipse.hyades.statistical.ui.editor.internal.*;
import org.eclipse.emf.common.util.URI;


public class JonasModuleTrace extends CommonModuleTrace 
{
	String reg_host_name = null;
	
	public JonasModuleTrace(StatConInterface statcon, String rac_host, String port, String jonasHost, URI smodelpath, URI monitor_uri) {
		super();
		
		//create the initial commands to pass to our agent
		SetVariableCommand[] reg_commands = new SetVariableCommand[] {
				new SetVariableCommand(JonasConstants.JONAS_HOST,jonasHost),				
				new SetVariableCommand(JonasConstants.PORT,port)				
			};
		
		init(	statcon,
				rac_host,
				"JonasAgent",
				JonasConstants.AGENT_PREFIX,
				" ("+rac_host+")",
				PerfmonPlugin.getString("JONAS_AGENT"),
				reg_commands,
				smodelpath,
				monitor_uri
				);
		
		//
		// we can register any specialist actions here
		//
//		agent.eAdapters().add(new ErrorListener());
	}	
}