/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.jonas.internal;

import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.utils.internal.JobLauncher;
import org.eclipse.hyades.statistical.ui.editor.internal.*;

import org.eclipse.hyades.perfmon.common.internal.*;

import org.eclipse.ui.dialogs.*;
import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.*;
import org.eclipse.core.resources.*;

import java.util.*;
import java.text.*;
import java.io.*;

import org.w3c.dom.*;
import javax.xml.parsers.*;

public class JonasStatConModule implements StatConModule {

ArrayList traces = new ArrayList();

ImageManager img = PerfmonPlugin.img;

StatConInterface statcon;
boolean ica = false;
	
String JONAS_NODE = "JONAS_NODE_ID";

String NEW_JONAS_TRACE = "NEW_TRACE_ID";

static String ACTION_SETSMODELPATH = "Set Statistical Model save path...";

URI smodelpath = null;

SimpleDateFormat smodel_sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");

	public JonasStatConModule() {
	}

	static String uriToHumanReadable(URI uri) {
		String path = uri.path();
		if (path.toLowerCase().startsWith("/resource/")) {
			path = path.substring(10);
		}
		return path;
	}
	
	private void redoActions() {
		statcon.addModuleNodeAction(JONAS_NODE,ACTION_SETSMODELPATH,PerfmonPlugin.getString("ACTION_SETSMODELPATH")+" ("+uriToHumanReadable(smodelpath)+")", img.getImage(ImageManager.IMG_PERFMON_SAVE), new PerfmonSetPath());
	}	
	
	public void load(StatConInterface statcon) throws Exception {
		this.statcon = statcon;

		smodelpath = statcon.getCurrentProjectURI();
		
		//add a perfmon trace node
		try {
			statcon.addModuleNode(PerfmonPlugin.getString("DATACOLLECTION_NODE"),PerfmonPlugin.DATACOLLECTION_NODE_ID,img.getImage(ImageManager.IMG_PERFMON_LOGO));
		} catch (EntityExistsException e) {}
		statcon.addModuleNode(PerfmonPlugin.getString("JONAS_NODE"),JONAS_NODE,PerfmonPlugin.DATACOLLECTION_NODE_ID,img.getImage(ImageManager.IMG_PERFMON_SERVER));
		statcon.addModuleNodeAction(JONAS_NODE,NEW_JONAS_TRACE,PerfmonPlugin.getString("NEW_JONAS_TRACE"),img.getImage(ImageManager.IMG_PERFMON_START),new NewTraceAction());		
		statcon.addModuleNodeAction(JONAS_NODE,ACTION_SETSMODELPATH,PerfmonPlugin.getString("ACTION_SETSMODELPATH")+" ("+uriToHumanReadable(smodelpath)+")", img.getImage(ImageManager.IMG_PERFMON_SAVE), new PerfmonSetPath());

	}
	public void applyConfig(String xml) throws Exception {
		//do nothing
	}
	public void loadModuleData(byte[] dat) throws Exception {
		//read the statistical model URI from the statcon file, should really do this with XML

		PerfmonPlugin.DBG.info("loading perfmon module data: "+new String(dat));

		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setValidating(false);
		
		DocumentBuilder builder = factory.newDocumentBuilder();

		Document doc = builder.parse(new ByteArrayInputStream(dat));

		Element element = doc.getDocumentElement();

		ArrayList list = XMLConfigUtil.getAllElements(element.getChildNodes(),"config");
		
		IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

		for (int i = 0; i < list.size(); i++) {
			Element elem = (Element)list.get(i);
		
			String path = elem.getAttribute("smodelpath");
			if (path != null) {
				if (path.length() > 0) {
					try {
						IFile tfile = workspaceRoot.getFile(new Path(path));
						smodelpath = URI.createPlatformResourceURI(tfile.getProjectRelativePath().toString());
					} catch (Throwable x) {
						PerfmonPlugin.DBG.info("invalid valid statistical model save path specified");
					}
				}	
			}	
		}
		
		redoActions();
	}
	public byte[] saveModuleData() throws Exception {
		//save the statistical model URI to the statcon file, should be XML
		
		StringBuffer xml = new StringBuffer();
		xml.append("<perfmon_config>\n");
		xml.append("  <config smodelpath=\""+smodelpath+"\" />\n");
		xml.append("</perfmon_config>\n");
		
		PerfmonPlugin.DBG.info("saving perfmon module data:"+xml);
		
		return xml.toString().getBytes();
	}

	public String getModuleRef() {
		return "org.eclipse.hyades.perfmon";
	}	
	
	public void unload() throws Exception {
		statcon.removeModuleNode(JONAS_NODE);
		
		for (int i = 0; i < traces.size(); i++) {
			Object t = traces.get(i);
			{
				CommonModuleTrace trace = ((CommonModuleTraceLaunchJob)t).getModuleTrace();
				try {
					trace.unloadTrace();
				} catch (Exception e) {
					PerfmonPlugin.DBG.warning("failed to unload trace "+i);
				}					
			}			
		}
	}
	
	class PerfmonSetPath implements Runnable {
		public void run() {
			PerfmonPlugin.DBG.info("set test model save path");

			IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
			Path container_savepath = null;
			IContainer container = null;
			try {
				container_savepath = new Path(""+smodelpath);
				container = workspaceRoot.getFolder(container_savepath);
			} catch (Throwable e) {
				PerfmonPlugin.DBG.warning("could not find valid IContainer for model save path");
			}

			PerfmonPlugin.DBG.info("showing container selection dialog");
			//pop up a dialog	
			ContainerSelectionDialog dialog = null;
			dialog = new ContainerSelectionDialog(statcon.getGraphWindow().getShell(), container, false, PerfmonPlugin.getString("SMODEL_SELECT_PATH_DESCRIPTION"));
			dialog.open();
			Object[] result = dialog.getResult();

			if (result != null) 
			{			
				if (result.length > 0) 
				{

					Path container_path = (Path)result[0];
					URI savepath = URI.createPlatformResourceURI(container_path.toString());

					smodelpath = savepath;

					PerfmonPlugin.DBG.info("updating menuitems to reflect new model save path");
					
					redoActions();
					statcon.setDirty(true);
				}
			}
		}			
	}	
	
	public void startJonasTrace(String rac_host, String jonasHost, String port, URI smodel_path) 
	{		
	    JonasModuleTrace trace = new JonasModuleTrace(statcon,rac_host,port, jonasHost,smodel_path,null);

		CommonModuleTraceLaunchJob job = new CommonModuleTraceLaunchJob(PerfmonPlugin.getString("PROGRESS_LAUNCHING"),trace);
		JobLauncher.launch(job);

		traces.add(job);
	}
	
	class NewTraceAction implements Runnable {
		public void run() {
			
			try {

				//pop up a dialog here
				
				JonasHostDialog dialog = new JonasHostDialog(statcon.getGraphWindow().getShell());
				dialog.open();
				
				String rac_host = dialog.getRacHost();
				String jonas_host = dialog.getJonasHost();				
				String port = dialog.getPort();				
				
				if (rac_host == null) return;

				startJonasTrace(rac_host,jonas_host, port,smodelpath);
			} catch (Throwable t) {
				PerfmonPlugin.DBG.error("error starting jonas trace",t);	
			}
			
		}
	}
	
}