/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.models.common.datapool.DPLRole;
import org.eclipse.hyades.models.common.datapool.DPLVariable;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>DPL Variable</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl#getRole <em>Role</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl#getVariables <em>Variables</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DPLVariableImpl extends CMNNamedElementImpl 
                             implements DPLVariable
{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "";

    /**
     * The default value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
	protected static final String TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
	protected String type = TYPE_EDEFAULT;

    /**
     * The default value of the '{@link #getRole() <em>Role</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getRole()
     * @generated
     * @ordered
     */
	protected static final DPLRole ROLE_EDEFAULT = DPLRole.UNSPECIFIED_DATA_LITERAL;

    /**
     * The cached value of the '{@link #getRole() <em>Role</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getRole()
     * @generated
     * @ordered
     */
	protected DPLRole role = ROLE_EDEFAULT;

    /**
     * The cached value of the '{@link #getVariables() <em>Variables</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getVariables()
     * @generated
     * @ordered
     */
	protected EList variables = null;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DPLVariableImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass()
    {
        return Common_DatapoolPackage.eINSTANCE.getDPLVariable();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String getType()
    {
        return type;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setType(String newType)
    {
        String oldType = type;
        type = newType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_VARIABLE__TYPE, oldType, type));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public DPLRole getRole()
    {
        return role;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setRole(DPLRole newRole)
    {
        DPLRole oldRole = role;
        role = newRole == null ? ROLE_EDEFAULT : newRole;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_VARIABLE__ROLE, oldRole, role));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getVariables()
    {
        if (variables == null)
        {
            variables = new EObjectContainmentEList(DPLVariable.class, this, Common_DatapoolPackage.DPL_VARIABLE__VARIABLES);
        }
        return variables;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_DatapoolPackage.DPL_VARIABLE__VARIABLES:
                    return ((InternalEList)getVariables()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_DatapoolPackage.DPL_VARIABLE__ID:
                return getId();
            case Common_DatapoolPackage.DPL_VARIABLE__DESCRIPTION:
                return getDescription();
            case Common_DatapoolPackage.DPL_VARIABLE__NAME:
                return getName();
            case Common_DatapoolPackage.DPL_VARIABLE__TYPE:
                return getType();
            case Common_DatapoolPackage.DPL_VARIABLE__ROLE:
                return getRole();
            case Common_DatapoolPackage.DPL_VARIABLE__VARIABLES:
                return getVariables();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(EStructuralFeature eFeature, Object newValue)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_DatapoolPackage.DPL_VARIABLE__ID:
                setId((String)newValue);
                return;
            case Common_DatapoolPackage.DPL_VARIABLE__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case Common_DatapoolPackage.DPL_VARIABLE__NAME:
                setName((String)newValue);
                return;
            case Common_DatapoolPackage.DPL_VARIABLE__TYPE:
                setType((String)newValue);
                return;
            case Common_DatapoolPackage.DPL_VARIABLE__ROLE:
                setRole((DPLRole)newValue);
                return;
            case Common_DatapoolPackage.DPL_VARIABLE__VARIABLES:
                getVariables().clear();
                getVariables().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_DatapoolPackage.DPL_VARIABLE__ID:
                setId(ID_EDEFAULT);
                return;
            case Common_DatapoolPackage.DPL_VARIABLE__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case Common_DatapoolPackage.DPL_VARIABLE__NAME:
                setName(NAME_EDEFAULT);
                return;
            case Common_DatapoolPackage.DPL_VARIABLE__TYPE:
                setType(TYPE_EDEFAULT);
                return;
            case Common_DatapoolPackage.DPL_VARIABLE__ROLE:
                setRole(ROLE_EDEFAULT);
                return;
            case Common_DatapoolPackage.DPL_VARIABLE__VARIABLES:
                getVariables().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_DatapoolPackage.DPL_VARIABLE__ID:
                return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
            case Common_DatapoolPackage.DPL_VARIABLE__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case Common_DatapoolPackage.DPL_VARIABLE__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case Common_DatapoolPackage.DPL_VARIABLE__TYPE:
                return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
            case Common_DatapoolPackage.DPL_VARIABLE__ROLE:
                return role != ROLE_EDEFAULT;
            case Common_DatapoolPackage.DPL_VARIABLE__VARIABLES:
                return variables != null && !variables.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (type: ");
        result.append(type);
        result.append(", role: ");
        result.append(role);
        result.append(')');
        return result.toString();
    }

	//Beginning of non-generated classes
	
	//org.eclipse.hyades.edit.datapool.IDatapoolVariable methods
	
	IDatapoolSuggestedType suggestedType = null;
	
	/**
	 * Define the {@link IDatapoolSuggestedType type} associated with this variable.
	 * 
	 * @param	suggestedType	The {@link IDatapoolSuggestedType type} associated 
	 *							with this variable.
	 * 
	 * @see #getSuggestedType()
	 */
	public void setSuggestedType(IDatapoolSuggestedType suggestedType)
	{
		this.setType(suggestedType.getSuggestedClassName());		
		this.suggestedType = suggestedType;

		//notify datapool listener  
		DPLDatapoolSpec dpSpec = (DPLDatapoolSpec)this.eContainer();
		if(dpSpec == null)
			return;
		DPLDatapool dp = (DPLDatapool)dpSpec.eContainer();	
		if(dp == null)
			return;	
		IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
		if (l != null)
			l.variableChanged((IDatapool)dp, 
							  dp.getDatapoolSpec().getVariables().indexOf(this));				
	}
		
	
	/**
	 * Define the role associated with a variable.
	 * 
	 * @param	role	The role to associate with a variable.
	 * 
	 * @see #getRole()
	 * @see	#ROLE_UNSPECIFIED
	 * @see	#ROLE_INPUT_DATA
	 * @see	#ROLE_OUTPUT_DATA
	 * @see	#ROLE_INPUT_OUTPUT_DATA
	 * @see	#ROLE_VERIFICATION_DATA
	 */
	public void setRole(int role)
	{
		this.setRole(DPLRole.get(role));
	}
	
	//org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable methods
		
	/**
	 * The {@link IDatapoolSuggestedType suggested type} of the data associated
	 * with this variable.  As implied by the name there is no enforcement of
	 * the type of data in any cell of the datapool.  However, an editor could 
	 * take advantage of the type information to improve display and editing of
	 * cells within the display.
	 * 
	 * @return	The {@link IDatapoolSuggestedType suggested type} associated with
	 *			this variable.
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolSuggestedType getSuggestedType()
	{
		if(suggestedType == null)
		{
			suggestedType = new DatapoolSuggestedTypeImpl();
			try
			{		
				suggestedType.setSuggestedType(Integer.parseInt(this.getType()));
			}
			catch(NumberFormatException e)
			{
				suggestedType.setSuggestedType(IDatapoolSuggestedType.TYPE_COMPLEX);
				suggestedType.setSuggestedClassName(this.getType());
			}
			catch(DatapoolException e)
			{
				suggestedType.setSuggestedType(IDatapoolSuggestedType.TYPE_COMPLEX);
				suggestedType.setSuggestedClassName(this.getType());				
			}
		}
		return (org.eclipse.hyades.execution.runtime.datapool.IDatapoolSuggestedType)suggestedType;      
	}

		
	/**
	 * Accesor for the role associated with a variable.  The role may be
	 * used by an editor to control the type of data that may be applied to 
	 * an individual cell with a datapool.
	 * 
	 * @return The role associated with a variable.
	 * 
	 * @see	#ROLE_UNSPECIFIED
	 * @see	#ROLE_INPUT_DATA
	 * @see	#ROLE_OUTPUT_DATA
	 * @see	#ROLE_INPUT_OUTPUT_DATA
	 * @see	#ROLE_VERIFICATION_DATA
	 */
	public int getRoleAsInt()
	{
		return this.getRole().getValue();
	}

	public void setName(String name)
	{
		super.setName(name);

		//notify datapool listener  
		DPLDatapoolSpec dpSpec = (DPLDatapoolSpec)this.eContainer();
		if(dpSpec == null)
			return;
		DPLDatapool dp = (DPLDatapool)dpSpec.eContainer();	
		if(dp == null)
			return;	
		IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
		if (l != null)
			l.variableChanged((IDatapool)dp, 
							  dp.getDatapoolSpec().getVariables().indexOf(this));		
	}

} //DPLVariableImpl
