/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

import java.util.List;

/**
 * 
 * A deployable component is anything that can be deployed and invoked as part
 * of a test.  The component is characterized by a location and a resource that 
 * specifies where and what is to be invoked.  Each deployable component can 
 * belong to one and only one test suite.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface IDeployableComponent extends INamedElement {
	/**
	 * Returns the test suite that owns this deployable component.
	 * 
	 * <p>This reference is bidirectional and its opposite is 
	 * {@link ITestSuite#getTestComponents()}.
	 * 
	 * @return ITestSuite
	 */
	public ITest getOwner();

	/**
	 * Returns the resource of the deployable component.
	 * 
	 * @return String
	 */	
	public String getResource();

	/**
	 * Sets the resource of the deployable component.
	 * 
	 * @param resource
	 */	
	public void setResource(String resource);
	
	/**
	 * Returns the location of the deployable component.
	 * 
	 * @return String
	 */		
	public String getLocation(); 
	
	/**
	 * Sets the location of the deployable component.
	 * 
	 * @param location
	 */	
	public void setLocation(String location);
	
	/**
	 * Gets the methods of this component.
	 * 
	 */		
	public List getMethods();

	/**
	 * Gets the environment variables associated with this component.
	 * 
	 */		
	public IPropertyGroup getEnvironmentVariables();
	
}