/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

/**
 * 
 * Tests can have collections of variables.  Each variable in a test's collection
 * represents a declared variable within the test, with scope spanning the entire
 * test.  Variables in a test suite are in scope for all of the test suite's 
 * contained test cases.
 * 
 * @author jtoomey
 * @author psun
 * @since 0.0.1
 */
public interface IVariable extends INamedElement {

	/**
	 * @return the type of the variable
	 */
	public String getType();
	
	/**
	 * Sets the type of the variable
	 * @param type
	 */
	public void setType(String type);
	
	/**
	 * @return the initial value of the variable
	 */
	public String getInitialValue();
	
	/**
	 * Sets the initial value of the variable
	 * @param initialValue
	 */
	public void setInitialValue(String initialValue);
}
