/**********************************************************************
Copyright (c) 2003 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author IBM
 *
 * This is an interface for the console handler
 */
public interface IProcessConsole {

	/**
	 * Get the standard input stream for writing to console
	 * @return OutputStream
	 */
	OutputStream getStandardInputStream();

	/**
	 * Get the standard output stream for reading from console
	 * @return InputStream
	 */
	InputStream getStandardOutputStream();

	/**
	 * Get the standard error stream for reading from console
	 * @return InputStream
	 */
	InputStream getStandardErrorStream();

}
