/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.core.impl;

import java.io.File;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IOrderedProperty;

/**
 * @author jtoomey
 */
public class JavaExecutionEnvironment extends ExecutionEnvironmentImpl {

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.impl.ExecutionEnvironmentImpl#setEnv(org.eclipse.hyades.execution.core.IOrderedProperty)
	 */
	public void setEnv(IOrderedProperty env) 
		throws ExecutionComponentStateException 
	{
		super.setEnv(env);
		
		// If the environment variable that is being set is the "CLASSPATH"
		// variable, set the system classpath variable to this value.
		// (this will be picked up by our custom class loader and
		// used to load the classes needed by the test.)
		if ( env.getName().equalsIgnoreCase("classpath"))
		{
			// TODO: check to make sure there is only one property.
			// May need to create a semicolon separated string from
			// array, though we won't use that ourselves. 
			System.setProperty("java.class.path", ((String) env.getValues()[0]));
			System.out.println("setting classpath to " + ((String) env.getValues()[0]));
		}
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#addEnv(org.eclipse.hyades.execution.core.IOrderedProperty)
	 */
	public void addEnv(IOrderedProperty env)
		throws ExecutionComponentStateException {
		// TODO Auto-generated method stub
		super.addEnv(env);
		System.out.println("I got called.!");
		
		// If the environment variable that is being set is the "CLASSPATH"
		// variable, set the system classpath variable to this value.
		// (this will be picked up by our custom class loader and
		// used to load the classes needed by the test.)
		if ( env.getName().equalsIgnoreCase("classpath"))
		{
			// Append to the existing value.
			String origClasspath = System.getProperty("java.class.path", ".");
			StringBuffer buf = new StringBuffer(origClasspath);
			buf.append(File.pathSeparatorChar);
			buf.append((String)env.getValues()[0]);
			
			// TODO: check to make sure there is only one property.
			// May need to create a semicolon separated string from
			// array, though we won't use that ourselves. 
			System.setProperty("java.class.path", buf.toString());
			System.out.println("system classpath is now: " + System.getProperty("java.class.path"));
		}
	}

}
