package org.eclipse.hyades.execution.core.impl;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.eclipse.hyades.execution.core.IExecutor;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class JavaTaskExecutableObject implements IJavaTaskExecutableObject {

	private IExecutor executor;
	private String name; 
	private Thread jobRunnerThread;
	
	public void init() {
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#getName()
	 */
	public String getName() {
		return name;
	}

	/** 
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#setExecutor(org.eclipse.hyades.execution.core.IExecutor)
	 */
	public void setExecutor(IExecutor obj) {
		this.executor=obj;
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#getExecutor()
	 */
	public IExecutor getExecutor() {
		return executor;
	}
	
	public void run() {
		// TODO: Call the actual test here!

		System.out.println("Default JavaTaskExcutableObject.run() behavior");
		
	}
	
	public void stop() {
		if(jobRunnerThread!=null && jobRunnerThread.isAlive()) {
			jobRunnerThread.stop();
		}
	}
	
	public void start() {
		
		Runnable job= new Runnable() {
			public void run() {
				JavaTaskExecutableObject.this.run();
			}
		}; 
		/* create a thread to run this job on */
		jobRunnerThread=new Thread(job, "JavaTaskExecutableObject Runner");
		jobRunnerThread.start();
	}
}
