/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.internal.sdb.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.hyades.loaders.util.ResourceExtensions;
import org.eclipse.hyades.models.internal.sdb.SDBPlugin;
import org.eclipse.hyades.models.internal.sdb.util.SDBXMLResourceLoader;


public class SDBResourceFactoryImpl extends XMIResourceFactoryImpl {
    //~ Constructors -------------------------------------------------------------------------------

    public SDBResourceFactoryImpl() {
        super();
    }

    //~ Methods ------------------------------------------------------------------------------------

    public Resource createResource(URI uri) {
        XMIResourceImpl r = new XMIResourceImpl(uri)
        {
        /* (non-Javadoc)
		 * @see org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl#createXMLLoad()
		 */
		protected XMLLoad createXMLLoad()
		{
			SDBXMLResourceLoader resourceLoader = null;

			try {
				resourceLoader = (SDBXMLResourceLoader) ResourceExtensions.getInstance().get(getURI().fileExtension());

				if (resourceLoader != null) {
					resourceLoader = (SDBXMLResourceLoader) resourceLoader.getClass().newInstance();
					resourceLoader.setXMLHelper(createXMLHelper());
				}
			} catch (Exception e) {
				SDBPlugin.log(e.getLocalizedMessage());
			}

			if (resourceLoader == null) {
				return super.createXMLLoad();
			}

			return resourceLoader;
		}}
		;

        r.setEncoding("UTF-8");
        r.setUseZip(true);

        return r;
    }
}
