/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.collection.correlation;

/**
 * This interfaces defines the transport mechanism between correlation engines.  In general, each mechanism should
 * be independent of correlation data.
 * 
 * @author Qiyan Li
 */
public interface ITransport
{
    /**
     * Send a request.
     * 
     * @param data      the data buffer to be sent
     * @param offset    the starting position of the data to be sent
     * @param length    the length (in bytes) of the data to be sent
     */
    public void sendRequest(byte[] data, int offset, int length);

    /**
     * Receive a request.
     * 
     * @return  request received.
     */
    public byte[] receiveRequest();

    /**
     * Send a reply.
     * 
     * @param data      the data buffer to be sent
     * @param offset    the starting position of the data to be sent
     * @param length    the length (in bytes) of the data to be sent
     */
    void sendReply(byte[] data, int offset, int length);

    /**
     * Receive a reply.
     * 
     * @return  reply received.
     */
    public byte[] receiveReply();
}
