/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import java.util.Iterator;

import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;

/**
 * @author sveyrier
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ShowNodeEnd extends Action{
		
	protected SDView viewer = null;
	
	public ShowNodeEnd (IViewPart view)
	{
		if (view instanceof SDView)
			viewer = (SDView)view;
	}
	
	public void run ()
	{
		if (viewer == null)
			return;
		SDWidget sdWidget = viewer.getSDWidget();
		
		ISelectionProvider selProvider = sdWidget.getSelectionProvider();
		ISelection sel=selProvider.getSelection();
		Object selectedNode= null;
		Iterator  it = ((StructuredSelection)sel).iterator();
		while (it.hasNext())
			selectedNode = it.next();
		if (selectedNode != null)
		{
			GraphNode node = (GraphNode)selectedNode;
			if ((node.getX()+node.getWidth())*sdWidget.getZoomFactor()<sdWidget.getContentsX()+sdWidget.getVisibleWidth()/2)
				sdWidget.ensureVisible(Math.round((node.getX()+node.getWidth())*sdWidget.getZoomFactor())-sdWidget.getVisibleWidth()/2,
								Math.round((node.getY()+node.getHeight())*sdWidget.getZoomFactor()));
			else sdWidget.ensureVisible(Math.round((node.getX()+node.getWidth())*sdWidget.getZoomFactor()+sdWidget.getVisibleWidth()/2),
						Math.round((node.getY()+node.getHeight())*sdWidget.getZoomFactor()));
		}
	}
}
