/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.drawings.impl;

import org.eclipse.hyades.uml2sd.ui.drawings.IFont;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

/**
 * @author sveyrier
 *
 */
public class FontImpl implements IFont{
	
	protected Font font = null;
	protected boolean manageFont= true;
	
	public FontImpl (Display display,FontData data)
	{
		font = new Font(display, data);
	}

	private FontImpl (Font value)
	{
		font = value;
		manageFont = false;
	}

	public Object getFont() {
		return font;
	}
	
	public static FontImpl getSystemFont()
	{
		return new FontImpl(Display.getDefault().getSystemFont());
	}
	
	public void dispose()
	{
		if (font!= null)
		font.dispose();
	}

}
