/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ztest;

import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;


public class ToolBox extends Window implements ISelectionListener{
	
	private Button changeName;
	
	private SDView view;

	private Text nodeName;

	private Button createEvent;

	private Text startEvent;

	private Text endEvent;

	private Combo comb;

	private Button createMessage;

	private Text startExecEvent;

	private Text endExecEvent;

	private Button createExec;

	public ToolBox(Shell parent, SDView v)
	{
		super(parent);
		view=v;
		
	}
	
	private GridData newGridData(int span)
	{
		
		GridData data = new GridData(GridData.GRAB_VERTICAL
				| GridData.VERTICAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL
				| GridData.HORIZONTAL_ALIGN_FILL);
		data.horizontalSpan=span;
		return data;
	}
	
	public GraphNode getFirstSelectedObject() 
	{
		ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService()
					.getSelection();
		if ((sel!=null)&&(sel instanceof StructuredSelection))
		{
			StructuredSelection stSel=(StructuredSelection)sel;
			if (stSel.getFirstElement() instanceof GraphNode)
			{
				return (GraphNode)stSel.getFirstElement();
			}
		}
		return null;
	}
	
	public GraphNode getSecondSelectedObject() 
	{
		ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService()
					.getSelection();
		if ((sel!=null)&&(sel instanceof StructuredSelection))
		{
			StructuredSelection stSel=(StructuredSelection)sel;
			if (stSel.getFirstElement() instanceof GraphNode)
			{
				Object arr[]=stSel.toArray();
				if ((arr.length>1)&&(arr[1] instanceof GraphNode))
					return (GraphNode)arr[1];
					
			}
		}
		return null;
	}
	
	protected Control createContents(Composite parent)
	{
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService()
				.addPostSelectionListener(this);
		GridLayout parentLayout = new GridLayout();
		parentLayout.numColumns = 2;
		parent.setLayout(parentLayout);
		
		
		Group g1 = new Group(parent,SWT.SHADOW_NONE);
		g1.setLayoutData(newGridData(2));
		GridLayout kindSelectionLayout = new GridLayout();
		kindSelectionLayout.numColumns = 2;
		g1.setLayout(kindSelectionLayout);	
		
		changeName = new Button(g1, SWT.PUSH);
		changeName.setText("Change graph node name"); //$NON-NLS-1$
		changeName.setLayoutData(newGridData(1));
		changeName.setEnabled(false);
		changeName.addSelectionListener(new SelectionListener() 
		{

			public void widgetSelected(SelectionEvent e) {
				GraphNode node=getFirstSelectedObject();
				if (node!=null)
				{
					node.setName(nodeName.getText());
					view.getSDWidget().redraw();
				}
			}

			public void widgetDefaultSelected(SelectionEvent e) {

			}

		});
		
		nodeName = new Text(g1,SWT.SINGLE|SWT.BORDER);
		nodeName.setLayoutData(newGridData(1));
		
		Button createLifeline=new Button(g1,SWT.PUSH);
		createLifeline.setText("Create lifeline"); //$NON-NLS-1$
		createLifeline.setLayoutData(newGridData(2));
		createLifeline.addSelectionListener(new SelectionListener() 
		{

			public void widgetSelected(SelectionEvent e) {
				if (view.getFrame()==null)
				{
					Frame frame=new Frame();
					view.setFrame(frame);
				}
				Frame frame=view.getFrame();
				Lifeline l = new Lifeline();
				frame.addLifeLine(l);
				view.getSDWidget().redraw();
			}

			public void widgetDefaultSelected(SelectionEvent e) {

			}

		});
		
		
		createEvent = new Button(g1,SWT.PUSH);
		createEvent.setText("Create event occurrence"); //$NON-NLS-1$
		createEvent.setLayoutData(newGridData(2));
		createEvent.setEnabled(false);
		createEvent.addSelectionListener(new SelectionListener() 
		{

			public void widgetSelected(SelectionEvent e) {
				GraphNode node=getFirstSelectedObject();
				if ((node!=null)&&(node instanceof Lifeline))
				{
					int event=((Lifeline)node).getNewEventOccurrence();
					startEvent.setText(new Integer(event).toString());
					view.getSDWidget().redraw();
				}
			}

			public void widgetDefaultSelected(SelectionEvent e) {

			}

		});
		
		Label label=new Label(parent,SWT.SEPARATOR|SWT.HORIZONTAL|SWT.CENTER);
		label.setLayoutData(newGridData(2));
		
		Group g2 = new Group(parent,SWT.SHADOW_NONE);
		g2.setLayoutData(newGridData(2));
		GridLayout kindSelectionLayout2 = new GridLayout();
		kindSelectionLayout2.numColumns = 2;
		g2.setLayout(kindSelectionLayout2);
		
		
		Text startLifeline = new Text(g2,SWT.SINGLE|SWT.READ_ONLY);
		startLifeline.setText("Start lifeline"); //$NON-NLS-1$
		GridData data=newGridData(1);
		data.horizontalAlignment=SWT.CENTER;
		startLifeline.setLayoutData(data);
		
		
		Text endLifeline = new Text(g2,SWT.SINGLE|SWT.READ_ONLY);
		endLifeline.setText("End lifeline"); //$NON-NLS-1$
		GridData data2=newGridData(1);
		data2.horizontalAlignment=SWT.CENTER;
		endLifeline.setLayoutData(data2);
		
		startEvent = new Text(g2,SWT.SINGLE|SWT.BORDER);
		GridData data5=newGridData(1);
		data5.horizontalAlignment=SWT.CENTER;
		startEvent.setLayoutData(data5);
		
		endEvent = new Text(g2,SWT.SINGLE|SWT.BORDER);
		GridData data6=newGridData(1);
		data6.horizontalAlignment=SWT.CENTER;
		endEvent.setLayoutData(data6);
		
		createMessage = new Button(g2,SWT.PUSH);
		createMessage.setText("Create message"); //$NON-NLS-1$
		createMessage.setLayoutData(newGridData(1));
		createMessage.addSelectionListener(new SelectionListener() 
		{

			public void widgetSelected(SelectionEvent e) {
				Lifeline l1=(Lifeline)getFirstSelectedObject();
				Lifeline l2=(Lifeline)getSecondSelectedObject();
				int event1=Integer.parseInt(startEvent.getText());
				int event2=Integer.parseInt(endEvent.getText());
				Frame frame=view.getFrame();
				switch (comb.getSelectionIndex()) {
				case 0:
				{
					SyncMessage m=new SyncMessage();
					m.setStartLifeline(l1);
					m.setEndLifeline(l2);
					frame.addMessage(m);
				}
					break;
				case 1:
				{
					SyncMessageReturn m=new SyncMessageReturn();
					m.setStartLifeline(l1);
					m.setEndLifeline(l2);
					frame.addMessage(m);
				}
					break;
				case 2:
				{
					AsyncMessage m=new AsyncMessage();
					m.setStartLifeline(l1);
					m.setEndLifeline(l2);
					m.setStartOccurrence(event1);
					m.setEndOccurrence(event2);
					frame.addMessage(m);
				}
					break;
				case 3:
				{
					AsyncMessageReturn m=new AsyncMessageReturn();
					m.setStartLifeline(l1);
					m.setEndLifeline(l2);
					m.setStartOccurrence(event1);
					m.setEndOccurrence(event2);
					frame.addMessage(m);
				}
					break;

				default:
					break;
				}
				view.getSDWidget().redraw();
			}

			public void widgetDefaultSelected(SelectionEvent e) {

			}

		});
		
		comb = new Combo(g2,SWT.DROP_DOWN);
		comb.add("Sync Mess"); //$NON-NLS-1$
		comb.add("Sync Mess Ret"); //$NON-NLS-1$
		comb.add("ASync Mess"); //$NON-NLS-1$
		comb.add("ASync Mess Ret"); //$NON-NLS-1$
		comb.select(0);
		
		
		Label label2=new Label(parent,SWT.SEPARATOR|SWT.HORIZONTAL|SWT.CENTER);
		label2.setLayoutData(newGridData(2));
		
		
		Group g3 = new Group(parent,SWT.SHADOW_NONE);
		g3.setLayoutData(newGridData(2));
		GridLayout kindSelectionLayout3 = new GridLayout();
		kindSelectionLayout3.numColumns = 2;
		g3.setLayout(kindSelectionLayout3);
		
		Text lifeline = new Text(g3,SWT.SINGLE|SWT.READ_ONLY);
		lifeline.setText("Lifeline events occurrences"); //$NON-NLS-1$
		GridData data7=newGridData(2);
		data7.horizontalAlignment=SWT.CENTER;
		lifeline.setLayoutData(data7);
		
		startExecEvent = new Text(g3,SWT.SINGLE|SWT.BORDER);
		GridData data8=newGridData(1);
		data8.horizontalAlignment=SWT.CENTER;
		startExecEvent.setLayoutData(data8);
		
		endExecEvent = new Text(g3,SWT.SINGLE|SWT.BORDER);
		GridData data9=newGridData(1);
		data9.horizontalAlignment=SWT.CENTER;
		endExecEvent.setLayoutData(data9);
		
		createExec = new Button(g3,SWT.PUSH);
		createExec.setText("Create execution"); //$NON-NLS-1$
		createExec.setLayoutData(newGridData(2));
		createExec.setEnabled(false);
		createExec.addSelectionListener(new SelectionListener() 
				{
					public void widgetSelected(SelectionEvent e) {
						Lifeline l1=(Lifeline)getFirstSelectedObject();
						int Event1=Integer.parseInt(startExecEvent.getText());
						int Event2=Integer.parseInt(endExecEvent.getText());
						Frame frame=view.getFrame();
						ExecutionOccurrence occ=new ExecutionOccurrence();
						occ.setLifeline(l1);
						occ.setStartOccurrence(Event1);
						occ.setEndOccurrence(Event2);
						l1.addExecution(occ);
						view.getSDWidget().redraw();
					}

					public void widgetDefaultSelected(SelectionEvent e) {
						
					}
				});
		return parent;
	}
	
	public boolean close()
	{
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService()
		.removePostSelectionListener(this);
		return super.close();
	}
	
	public void selectionChanged(IWorkbenchPart part, ISelection selection) 
	{
		changeName.setEnabled(false);
    	createEvent.setEnabled(false);
    	createMessage.setEnabled(false);
    	createExec.setEnabled(false);
    	startEvent.setText(""); //$NON-NLS-1$
    	endEvent.setText(""); //$NON-NLS-1$
    	int lifelineCount=0;
    	
		GraphNode node=getFirstSelectedObject();
		if (node!=null)
		{
			changeName.setEnabled(true);
			if (node instanceof Lifeline)
			{
				createEvent.setEnabled(true);
				createExec.setEnabled(true);
				startEvent.setText(new Integer(((Lifeline)node).getEventOccurrence()).toString());
				lifelineCount++;
			}
			else if (node instanceof BaseMessage)
			{
				BaseMessage m=(BaseMessage)node;
				int start=m.getEventOccurrence();
				int end=start;
				if (m instanceof AsyncMessage)
				{
					start=((AsyncMessage)m).getStartOccurrence();
					end=((AsyncMessage)m).getEndOccurrence();
				}
				if (m.getStartLifeline()!=null)
				{
					startEvent.setText(new Integer(start).toString());
				}
				if (m.getEndLifeline()!=null)
				{
					endEvent.setText(new Integer(end).toString());
				}
			}
			else
			{
				createEvent.setEnabled(false);
				startEvent.setText(""); //$NON-NLS-1$
			}
		}
		
		GraphNode node2=getSecondSelectedObject();
		if (node2!=null)
		{
			createEvent.setEnabled(false);
			changeName.setEnabled(false);
			createExec.setEnabled(false);
			if (node2 instanceof Lifeline)
			{
				endEvent.setText(new Integer(((Lifeline)node2).getEventOccurrence()).toString());
				lifelineCount++;
			}
			else
			{
				endEvent.setText(""); //$NON-NLS-1$
			}
		}
		if (lifelineCount==2)
			createMessage.setEnabled(true);
	    
	}

}
