/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLgcRootLoader.java,v 1.9 2004/11/22 21:48:51 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCGCRootType;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCHeapRoot;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;

/**
 * 
 * @author slavescu
 */
public class XMLgcRootLoader extends TraceXMLFragmentLoader {
    //~ Static fields/initializers -----------------------------------------------------------------

    protected static final String TYPE = "type";
    protected static final String HEAP_DUMP_ID_REF = "heapDumpIdRef";

    //~ Instance fields ----------------------------------------------------------------------------

    protected TRCGCRootType fType;
    protected short fHeapDumpId;

	private TRCHeapDump heapDump;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode(name)) {
        case TraceConstants.TYPE_int:
            fType = TRCGCRootType.get(value);

            break;
        case TraceConstants.HEAP_DUMP_ID_REF_int:
            fHeapDumpId = Short.parseShort(value);

            break;
        default:
            super.addAttribute(name, value);

            break;
        }
    }

    public void addYourselfInContext() {
        if (loadToModel) {
            if (objIdRef >= 0) {
                theProcess = getProcess();
                if(theProcess.getHeapDumps().size()>0)
                {
                	if(fHeapDumpId!=-1)
                		heapDump = (TRCHeapDump) LookupServiceExtensions.getInstance().locate(context,TRCHeapDumpImpl.class, LoadersUtils.getLookUpKey(fHeapDumpId));
                	if(heapDump==null)
                		heapDump = (TRCHeapDump)theProcess.getHeapDumps().get(theProcess.getHeapDumps().size()-1);
                	dispatchProcessMode(ProcessSteps.ALL);
                }
            }
        }
    }

    public void initialize(HierarchyContext context, String name) {
        loadToModel = context.isLoadToModel();

        super.initialize(context, name);
        fType = TRCGCRootType.UNKNOWN_LITERAL;
        fHeapDumpId=-1;
        heapDump=null;
    }

    protected void processHF(int step) { 
    	super.processHF(step); 

    	Class clazz = (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS) ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class); 

    	theObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, clazz, LoadersUtils.getLookUpKey(objIdRef)); 

    	if (theObject == null) { 
    		return; 
    	} 
    	
    	TRCHeapRoot heapRoot = TraceFactory.eINSTANCE.createTRCHeapRoot(); 
    	heapRoot.setType(fType); 
    	heapRoot.setHeapDump(heapDump); 
    	heapRoot.setObject(theObject); 
    	if (threadIdRef != 0) 
    		heapRoot.setThread(getThreadByIdRef(getProcess())); 
    }

 }
