/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLmethodReturnLoader.java,v 1.5 2004/11/22 21:48:51 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.trace.TraceUtils.InvocationInfo;
import org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo;


/**
 * @author slavescu
 *
 */
public class XMLmethodReturnLoader extends XMLmethodExitLoader {

    protected void processEF(int step) {
//        super.processEF(step);

        fullInvocation = ((InvocationInfo) cs.peek()).getMethodInvocation();

        if (fullInvocation != null) {
            theThread = fullInvocation.getThread();
            if(fullInvocation instanceof TRCCallerCalleeInvocationInfo)
            	((TRCCallerCalleeInvocationInfo)fullInvocation).setReturnTime(createDeltaTime());
            else
                fullInvocation.setExitTime(createDeltaTime());
            if(fullInvocation instanceof TRCCallerCalleeInvocationInfo)
            	((TRCCallerCalleeInvocationInfo)fullInvocation).setCallOverhead(overhead);
            else
            	fullInvocation.setOverhead(overhead);
            addInputOutputValues();
            
    		synchronized (REMOTE_INVOCATION_RESOLUTION_LOCK) {
    			updateForwardInvokes(fullInvocation);
    		}

//            updateStatisticalInfo();
            invocationPool.release((InvocationInfo) cs.pop());
        } else {
            // ignore method exit if there is no method entry
        }
    }

    protected void processES(int step) {
//        super.processES(step);

        //		theThread = getThreadByIdRef(theProcess);
        //		theMethod = fullInvocation.getMethod();
        //		theObject = fullInvocation.getOwningObject();
        //		theClass = theMethod.getDefiningClass();
//        updateStatisticalInfoOnly();
    }
}
