/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLmonContendedEnterLoader.java,v 1.5 2004/12/03 14:17:55 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;
public class XMLmonContendedEnterLoader extends TraceXMLFragmentLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	protected static final String THREAD_OWNER = "threadOwner";
	//~ Instance fields
	// ----------------------------------------------------------------------------
	protected int threadOwner;
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case TraceConstants.THREAD_OWNER_int :
				threadOwner = Integer.parseInt(value);
				break;
			default :
				super.addAttribute(name, value);
				break;
		}
	}
	public void addYourselfInContext() {
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		dispatchProcessMode(ProcessSteps.ALL);
		TRCThread lockingThread = null;
		if( threadOwner > 0) {
			lockingThread = (TRCThread) LookupServiceExtensions.getInstance().locate(context, TRCThreadImpl.class, LoadersUtils.getLookUpKey(threadOwner));
			//time to check dead lock:
			ArrayList wfls = new ArrayList();
			if( theThread!=lockingThread && checkCircularLock( theThread, lockingThread, wfls ) )
			{
			  //create dead lock event :
			  TRCThreadDeadLockEvent evt = TraceFactory.eINSTANCE.createTRCThreadDeadLockEvent();
			  evt.setLockedObject(theObject);
			  evt.setThread(theThread);
			  evt.setTime( createDeltaTime());
			  evt.setLockingThread( lockingThread );
			  
			  //create deadlock for wfl circular list:
			  int size=wfls.size();
			  TRCThreadDeadLockEvent last=evt;
			  for( int i=size-1; i>=0; --i )
			  {
			    TRCThreadWaitingForLockEvent wfl = (TRCThreadWaitingForLockEvent)wfls.get(i);
			    
			    TRCThreadDeadLockEvent nevt = TraceFactory.eINSTANCE.createTRCThreadDeadLockEvent();
			    nevt.setLockedObject( wfl.getLockedObject() );
			    nevt.setThread( wfl.getThread() );
			    nevt.setTime( createDeltaTime());
			    nevt.setLockingThread( wfl.getLockingThread() );
			    nevt.setNextDeadLockEvent( last );
			    wfl.getThread().getThreadEvents().add( nevt );
			    
			    last= nevt;
			  }			  
			  evt.setNextDeadLockEvent( last );
			  
			  theThread.getThreadEvents().add(evt );
			  //System.out.println("HAVE CREATE DEAD LOCK !!!!");
			  return ;
			}
		}
		//this is not a dead lock
		TRCThreadWaitingForLockEvent threadWaitingForLockEvent = TraceFactory.eINSTANCE.createTRCThreadWaitingForLockEvent();
		threadWaitingForLockEvent.setLockedObject(theObject);
		threadWaitingForLockEvent.setThread(theThread);
		threadWaitingForLockEvent.setTime(createDeltaTime());//time);
		if (threadOwner > 0) {
			threadWaitingForLockEvent.setLockingThread( lockingThread );
		}
		theThread.getThreadEvents().add(threadWaitingForLockEvent);
	}
	private boolean checkCircularLock( TRCThread stopThread, TRCThread checkIt, ArrayList wfls )
	{
	  if( checkIt==null ) return false;
	  EList evts = checkIt.getThreadEvents();
	  if( evts.size()==0 ) return false;
	  TRCThreadEvent last_event = (TRCThreadEvent)evts.get( evts.size()-1 );
	  if( last_event instanceof TRCThreadDeadLockEvent )
	  {
	    //stop Thread becomes deadlocked by contagion:
	    return true;
	  }
	  //waiting on a thread not locked.
	  if( !(last_event instanceof TRCThreadWaitingForLockEvent )) return false;
	  TRCThreadWaitingForLockEvent wfl = (TRCThreadWaitingForLockEvent)last_event;
	  wfls.add( wfl );
	  TRCThread locking = wfl.getLockingThread();
	  if( locking==stopThread ) return true;
	  return checkCircularLock( stopThread, locking, wfls );
	}
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		super.initialize(context, name);
		threadOwner = 0;
	}
	protected void processEF(int step) {
		super.processEF(step);
		if ((theObject == null) || !(theObject instanceof TRCFullTraceObject)) {
			theObject = (TRCFullTraceObject) LookupServiceExtensions.getInstance().locate(context, TRCFullTraceObjectImpl.class, LoadersUtils.getLookUpKey(objIdRef));
		}
	}
	/**
	 *  
	 */
	protected void processES(int step) {
		super.processES(step);
		if (objIdRef > 0) {
			virtualObject = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, LoadersUtils.getLookUpKey(objIdRef));
			if (virtualObject != null) {
				theObject = getClassObject(virtualObject.myClass, TRCFullTraceObjectImpl.class);
			} else {
				return;
			}
		} else {
			theObject = getClassObject(theClass, TRCFullTraceObjectImpl.class);
		}
	}
	/**
	 *  
	 */
	protected void processHF(int step) {
		super.processHF(step);
		Class clazz = (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS) ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class);
		if ((theObject == null) || !(theObject instanceof TRCHeapObject)) {
			theObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, clazz, LoadersUtils.getLookUpKey(objIdRef));
		}
	}
}